/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "render_2d.h"

#include "graphics_engine.h"
#include "class_list.h"
#include "element_2d.h"

#include "shell_command.h"
SHELL_COMMAND(toggleNodeVisibility, Render2D, toggleNodesVisibility);

using namespace std;

/**
 * standard constructor
 */
Render2D::Render2D ()
{
   this->setClassID(CL_RENDER_2D, "Render2D");
   this->setName("Render2D");

   this->showNodes = false;
}

/**
 *  the singleton reference to this class
 */
Render2D* Render2D::singletonRef = NULL;

/**
 * standard deconstructor
 */
Render2D::~Render2D ()
{
  delete Element2D::getNullElement();

  Render2D::singletonRef = NULL;
}

/**
 * updates all the 2d-elements
 * @param dt the timestep since last dt
 */
void Render2D::update(float dt)
{
  Element2D::getNullElement()->update2D(dt);
}


/**
 * ticks all the 2d-elements
 * @param dt the timestep since last dt
 */
void Render2D::tick(float dt)
{
  Element2D::getNullElement()->tick2D(dt);
}

/**
 * renders all the Elements of the Render2D-engine's layer
 * @param layer the Layer to draw (if E2D_LAYER_ALL then all layers will be drawn)
 */
void Render2D::draw(short layer) const
{
  GraphicsEngine::enter2DMode();
  Element2D::getNullElement()->draw2D(E2D_LAYER_ALL);
  if (this->showNodes)
    Element2D::getNullElement()->debugDraw2D(0);
  GraphicsEngine::leave2DMode();
}


