/*!
 * @file space_ship.h
 * Implements the Control of a Spaceship
 */

#ifndef _SPACE_SHIP_H
#define _SPACE_SHIP_H

#include "playable.h"
#include "extendable.h"

// Forward Declaration
template<class T> class tList;
class Vector;
class Event;
class ParticleEmitter;
class ParticleSystem;

class SpaceShip : public Playable
{

  public:
    SpaceShip(const std::string& fileName);
    SpaceShip(const TiXmlElement* root = NULL);
    virtual ~SpaceShip();

    virtual void loadParams(const TiXmlElement* root);

    virtual void setPlayDirection(const Quaternion& rot, float speed = 0.0f);

    virtual void enter();
    virtual void leave();

    virtual void reset();

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);

  private:
    void init();

    void calculateVelocity(float time);

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
//    bool                  bFire;              //!< fire button pressed.(moved to playable)
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    float                 mouseSensitivity;   //!< the mouse sensitivity
    int                   yInvert;
    int                   controlVelocityX;
    int                   controlVelocityY;
//    float                 cycle;              //!< hovercycle

    Vector                velocity;           //!< the velocity of the player.
    Vector                oldVelocity;        //!< the velocity the player had last synced
    Quaternion            mouseDir;           //!< the direction where the player wants to fly
    Quaternion            oldMouseDir;        //!< the direction where the player wanted to fly
    float                 shipInertia;        //!< the inertia of the ship(how fast the ship reacts to a mouse input)
    Quaternion            rotQuat;
    Quaternion            pitchDir;
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.

    float                 airViscosity;

    byte                  oldMask;            //!< used for synchronisation

    ParticleEmitter*      burstEmitter;
    ParticleSystem*       burstSystem;
};

#endif /* _SPACE_SHIPS_H */
