/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.


### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Wuest
*/

#define DEBUG_MODULE_NETWORK

#include "shared_network_data.h"
#include "network_stream.h"
#include "netdefs.h"

#include "state.h"

#include <cassert>

#include "synchronizeable.h"



/**
 *  default constructor
 */
Synchronizeable::Synchronizeable()
{
  this->setClassID(CL_SYNCHRONIZEABLE, "Synchronizeable");
  this->owner = -1;
  this->hostID = SharedNetworkData::getInstance()->getHostID();
  this->setIsServer(this->hostID == 0);
  this->uniqueID = NET_UID_UNASSIGNED;
  this->networkStream = NULL;
  this->bSynchronize = false;

  if( State::isOnline())
  {
    NetworkStream* nd = SharedNetworkData::getInstance()->getDefaultSyncStream();
    assert(nd != NULL);
    nd->connectSynchronizeable(*this);
    this->setUniqueID(SharedNetworkData::getInstance()->getNewUniqueID());
  }
  
  this->registerVar( new SynchronizeableString( &this->objectName, &this->objectName, "objectName" ) );
}



/**
 *  default destructor deletes all unneded stuff
 */
Synchronizeable::~Synchronizeable()
{
  if ( this->networkStream )
    this->networkStream->disconnectSynchronizeable(*this);
}

/**
 * Sets the server flag to a given value
 * @param isServer: the boolean value which the server flag is to set to
 */
void Synchronizeable::setIsServer(bool isServer)
{
  if( isServer )
    this->state = this->state | STATE_SERVER;
  else
    this->state = this->state & (~STATE_SERVER);
}


/**
 * Determines if the server flag is set
 * @return true, if the server flag is true, false else
 */
bool Synchronizeable::isServer()
{
  return (this->state & STATE_SERVER) >0;
}


/**
 * get the diff to last acked state of userId
 * @param userId user to create diff for
 * @param data buffer to copy diff in
 * @param maxLength max bytes to copy into data
 * @param stateId id of current state
 * @param priorityTH tells getStateDiff to not send element with priority \< priorityTH
 * @return n bytes copied into data
 */
int Synchronizeable::getStateDiff( int userId, byte* data, int maxLength, int stateId, int priorityTH )
{
#warning implement this
}

/**
 * sets a new state out of a diff created on another host
 * @param userId hostId of user who send me that diff
 * @param data pointer to diff
 * @param length length of diff
 * @param stateId id of current state
 * @return true on success
 */
bool Synchronizeable::setStateDiff( int userId, byte* data, int length, int stateId )
{
#warning implement this
}

 /**
 * override this function to be notified on change
 * of your registred variables.
 * @param id id's which have changed
 */
void Synchronizeable::varChangeHandler( std::list<int> & id )
{
#warning implement this
}

/**
 * registers a varable to be synchronized over network
 * @param var see src/lib/network/synchronizeable_var/ for available classes
 */
void Synchronizeable::registerVar( SynchronizeableVar * var )
{
#warning implement this
}

/**
 * registers a varable to be synchronized over network
 * return value is passed to varChangeHandler on change
 * @param var see src/lib/network/synchronizeable_var/ for available classes
 * @return handle passed to varChangeHandler on changes
 */
int Synchronizeable::registerVarId( SynchronizeableVar * var )
{
#warning implement this
}


