/*!
 * @file signalhandler.h
 * Defines game rules for this game
 */

#ifndef _SIGNAL_HANDLER_H
#define _SIGNAL_HANDLER_H

#include <list>
#include <string>

#define GDB_BT_FILE "orxonox.backtrace"

enum GdbRunType{
  GDB_RUN_WRITE_TO_FILE = 1,
  GDB_RUN_IN_FOREGROUND
};


#ifndef __WIN32__
#include <signal.h>

struct SignalRec
{
  int signal;
  sighandler_t handler;
};


typedef std::list<SignalRec> SignalRecList;

class SignalHandler
{
  private:
    SignalHandler();
  public:
    inline static SignalHandler* getInstance() { if (!SignalHandler::singletonRef) SignalHandler::singletonRef = new SignalHandler();
      return SignalHandler::singletonRef; }

    void doCatch( std::string appName, GdbRunType type = GDB_RUN_WRITE_TO_FILE );
    void dontCatch();

  private:
    static void sigHandler( int sig );

    void catchSignal( int sig );
    SignalRecList sigRecList;

    static SignalHandler * singletonRef;

    GdbRunType type;

    std::string appName;
};

#else /* if defined __WIN32__ */
class SignalHandler
{
 public:
  inline static SignalHandler* getInstance() {};
  void doCatch( std::string appName, GdbRunType type = GDB_RUN_WRITE_TO_FILE ) {};
  void dontCatch() {};
};
#endif

#endif /* _SIGNAL_HANDLER_H */

