/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
 *
 * @todo if the second string is a Command, the third should not be completed!
 * @todo also make some completion for registered (or special) Types
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

#include <vector>
#include <list>
#include <string>

// FORWARD DECLARATION
class BaseObject;

namespace OrxShell
{
  //! A class for Completing the an InputString.
  class ShellCompletion
  {
      //! an enumerator for different types the Shell can complete.
      typedef enum {
        NullCompletion         = 0,
        ClassCompletion        = 1,
        ObjectCompletion       = 2,
        FunctionCompletion     = 4,
        AliasCompletion        = 8,
    } CompletionType;

      //! A struct for ShellElements (these are used as containers to identify an Input for what it is)
      struct CompletionElement
      {
        std::string     name;     //!< the Name of the Element to be completed.
        CompletionType  type;     //!< the type of the Element
      };

    public:
      ShellCompletion();
      virtual ~ShellCompletion();


      // Functions to produce the Complete Lists.
      bool autoComplete(std::string& input);

      static const std::string& ShellCompletion::typeToString(ShellCompletion::CompletionType type);

    private:
      //  long classMatch(const char* input, unsigned int* length);
      bool objectComplete(const std::string& objectBegin, long classID);
      //  bool objectMatch(const char* objectBegin, long classID, unsigned int* length);
      bool commandComplete(const std::string& commandBegin, const std::string& className);
      //  bool functionMatch(const char* functionBegin, long classID, unsigned int* length);
      bool aliasComplete(const std::string& aliasBegin);

      // Generally Completes.
      bool generalComplete(std::string& input,
                           const std::string& begin, const std::string& displayAs = "%s",
                           const std::string& addBack = "", const std::string& addFront = "");


      bool addToCompleteList(const std::list<std::string>& inputList, const std::string& completionBegin, ShellCompletion::CompletionType type);
      bool addToCompleteList(const std::list<BaseObject*>& inputList, const std::string& completionBegin, ShellCompletion::CompletionType type);

      // Helpers.
      void clearCompletionList();

    private:
      std::vector<CompletionElement>  completionList;          //!< A list of completions, that are io.

      static const std::string        typeNames[];             //!< A list of Completion-Type-Names.
  };

}

#endif /* _SHELL_COMPLETION_H */
