/*!
 * @file shell_command_class.h
 * Definition of a on-screen-shell
 */

#ifndef _SHELL_COMMAND_CLASS_H
#define _SHELL_COMMAND_CLASS_H

#include "base_object.h"
#include <vector>


namespace OrxShell
{
  // FORWARD DECLARATION
  class ShellCommand;
  class ShellCommandAlias;

  //! A class to hold all Classes that have (once) registered Commands.
  class ShellCommandClass : public BaseObject
  {
    friend class ShellCommand;

  public:
    /** @returns the CommandClassList */
    static const std::vector<ShellCommandClass*>& getCommandClassList() { return ShellCommandClass::commandClassList; };

    static bool getCommandListOfClass(const std::string& className, std::list<std::string>& stringList);

    static ShellCommandClass* getCommandClass(const std::string& className);
    static void unregisterAllCommands();
    static const ShellCommandClass* exists(const std::string& className);

    static void help (const std::string& className);

  private:
    ShellCommandClass(const std::string& className);
    virtual ~ShellCommandClass();


    void registerCommand(ShellCommand* command);
    void unregisterCommand(ShellCommand* command);

  private:
    const std::string                      className;                 //!< The Name of the Class. This should match the ClassName of the Commands Class.
    long                                   classID;                   //!< The classID of this Class
    std::vector<ShellCommand*>             commandList;               //!< A list of Commands from this Class

    static std::vector<ShellCommandClass*> commandClassList;          //!< A list of Classes
  };

}

#endif /* _SHELL_COMMAND_H */
