/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SHELL

#include "shell_completion_plugin.h"
#include "shell_command_class.h"

#include "shell_command.h"

#include "substring.h"
#include "class_list.h"
#include "debug.h"

namespace OrxShell
{


  void CompletorStringArray::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin)
  {
    unsigned int inputLen = completionBegin.size();
    for (unsigned int i = 0; i < this->_size; ++i)
      if (!nocaseCmp(this->_stringArray[i], completionBegin, inputLen))
        completionList.push_back(this->_stringArray[i]);
  }



  CompletorList::CompletorList(const std::list<std::string>* list)
  {
    this->_list = list;
  }

  void CompletorList::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin)
  {
    unsigned int inputLen = completionBegin.size();
    std::list<std::string>::const_iterator it;
    for (it = this->_list->begin(); it != this->_list->end(); ++it)
      if (!nocaseCmp((*it), completionBegin, inputLen))
        completionList.push_back(*it);
  }



  CompletorFileSystem::CompletorFileSystem(const std::string& fileExtension,
      StartDirectory startDir,
      const std::string& subDir)
  : _fileExtension(fileExtension), _startDir(startDir), _subDir(subDir)
  {  }


  void CompletorFileSystem::addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin)
  {
    if (completionBegin.empty()) // if we do not yet have the beginning of the line, start with the chosen startDir.
    {


    }
  }

}

