/*!
 * @file shell_completion_plugin.h
 * @brief The Shell Completion Plugin
 */

#ifndef _SHELL_COMPLETION_PLUGIN_H
#define _SHELL_COMPLETION_PLUGIN_H

#include <list>
#include <vector>
#include <string>

namespace OrxShell
{
  //! The Base of All Completors
  class Completor
  {
    public:
      virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) = 0;
      virtual ~Completor() { };

    protected:
      Completor();
  };

  //! Completor that completes static Arrays of Strings.
  class CompletorStringArray : public Completor
  {
    public:
      CompletorStringArray(const std::string* stringArray, unsigned int size)
          : _stringArray(stringArray), _size(size) {};
      virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin);

    private:
      const std::string*   _stringArray;
      unsigned int         _size;
  };

  //! Completor that completes FileSystem Entries.
  class CompletorFileSystem : public Completor
  {

    public:
      // Where to search if the completionString is empty.
      typedef enum
      {
        StartAtRoot,
        StartAtHome,
        StartAtDataDir,
    } StartDirectory;

      CompletorFileSystem(const std::string& fileExtension = "",
                          StartDirectory startDir = StartAtDataDir,
                          const std::string& subDir = "");
      virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin);

    private:
      std::string             _fileExtension;
      std::string             _subDir;
      StartDirectory          _startDir;
  };


  //! A Templated Completor
  template<typename CLASS> class CompletorTList : public Completor
  {
    public:
      CompletorTList(const std::list<CLASS*>& completionList);
      virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin)
      {};
  };





  //! A class for Completing the an InputString.
  class CompletionPlugin
  {
    private:

    public:
      CompletionPlugin();


  };

}
#endif /* _SHELL_COMPLETION_PLUGIN_H */
