/*!
 * @file shell_command_class.h
 * Definition of a on-screen-shell
 */

#ifndef _SHELL_COMMAND_CLASS_H
#define _SHELL_COMMAND_CLASS_H

#include "base_object.h"
#include <list>


namespace OrxShell
{
  // FORWARD DECLARATION
  class ShellCommand;
  class ShellCommandAlias;

  //! A class to hold all Classes that have (once) registered Commands.
  class ShellCommandClass : public BaseObject
  {
    friend class ShellCommand;

  public:
    /** @returns the CommandClassList */
    static const std::list<ShellCommandClass*>* getCommandClassList() { return ShellCommandClass::commandClassList; };

    static bool getCommandListOfClass(const std::string& className, std::list<std::string>& stringList);
    static bool getCommandListOfAlias(std::list<std::string>& aliasList);

    static ShellCommandClass* getCommandClass(const std::string& className);
    static void unregisterAllCommands();

    static void help (const std::string& className);

  private:
    ShellCommandClass(const std::string& className);
    virtual ~ShellCommandClass();

    static const ShellCommandClass* isRegistered(const std::string& className);
    static void initCommandClassList();

  private:
    const std::string                      className;                 //!< The Name of the Class. This should match the ClassName of the Commands Class.
    long                                   classID;                   //!< The classID of this Class
    std::list<ShellCommand*>               commandList;               //!< A list of Commands from this Class
    static std::list<ShellCommandClass*>*  commandClassList;          //!< A list of Classes
    static std::list<ShellCommandAlias*>*  aliasList;                 //!< An Alias to A Command. (only for classes with one Instance)
  };

}

#endif /* _SHELL_COMMAND_H */
