/*!
 * @file shell_completion_plugin.h
 * @brief The Shell Completion Plugin
 */

#ifndef _SHELL_COMPLETION_PLUGIN_H
#define _SHELL_COMPLETION_PLUGIN_H

#include <list>
#include <vector>
#include <string>

namespace OrxShell
{
  class ShellCompletor
  {
  public:
    virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin) = 0;
    virtual ~ShellCompletor() { };

  protected:
    ShellCompletor();
  };

  class ShellCompletorStringArray : public ShellCompletor
  {
  public:
    ShellCompletorStringArray(const std::string* stringArray, unsigned int size)
      : _stringArray(stringArray), _size(size) {};
    virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin);

  private:
    const std::string*   _stringArray;
    unsigned int         _size;
  };


  //! A Templated Completor
  template<typename CLASS> class ShellCompletorTList : public ShellCompletor
  {
  public:
    ShellCompletorTList(const std::list<CLASS*>& completionList);
    virtual void addToCompleteList(std::vector<std::string>& completionList, const std::string& completionBegin)
    {};
  };


  //! A class for Completing the an InputString.
  class ShellCompletionPlugin
  {
  public:
    ShellCompletionPlugin();


  };

}
#endif /* _SHELL_COMPLETION_PLUGIN_H */
