/*!
 * @file shell_completion.h
 * @brief The Shell Completion Tasks
 *
 * @todo if the second string is a Command, the third should not be completed!
 * @todo also make some completion for registered (or special) Types
*/

#ifndef _SHELL_COMPLETION_H
#define _SHELL_COMPLETION_H

#include <list>
#include <string>

// FORWARD DECLARATION
class BaseObject;
class ShellInput;
#ifndef NULL
#define NULL 0            //!< a pointer to NULL
#endif


//! A class for ...
class ShellCompletion {

  //! an enumerator for different types the Shell can complete.
  typedef enum {
    SHELLC_NONE        = 0,
    SHELLC_CLASS       = 1,
    SHELLC_OBJECT      = 2,
    SHELLC_FUNCTION    = 4,
    SHELLC_ALIAS       = 8,
  } SHELLC_TYPE;

//! A struct for ShellElements (these are used as containers to identify an Input for what it is)
  struct ShellC_Element{
    std::string     name;     //!< the Name of the Element to be completed.
    SHELLC_TYPE     type;     //!< the type of the Element
  };

 public:
  ShellCompletion();
  virtual ~ShellCompletion();

  bool autoComplete(std::string& input);
  bool classComplete(const std::string& classBegin);
//  long classMatch(const char* input, unsigned int* length);
  bool objectComplete(const std::string& objectBegin, long classID);
//  bool objectMatch(const char* objectBegin, long classID, unsigned int* length);
  bool functionComplete(const std::string& functionBegin, const std::string& className);
//  bool functionMatch(const char* functionBegin, long classID, unsigned int* length);
  bool aliasComplete(const std::string& aliasBegin);

  bool generalComplete(std::string& input,
                       const std::string& begin, const std::string& displayAs = "%s",
                       const std::string& addBack = "", const std::string& addFront = "");


  bool addToCompleteList(const std::list<std::string>& inputList, const std::string& completionBegin, SHELLC_TYPE type);
  bool addToCompleteList(const std::list<BaseObject*>& inputList, const std::string& completionBegin, SHELLC_TYPE type);
  void clearCompletionList();

  static const char* ShellCompletion::typeToString(SHELLC_TYPE type);

 private:
   std::list<ShellC_Element>    completionList;          //!< A list of completions, that are io.
};

#endif /* _SHELL_COMPLETION_H */
