/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_LOADING

#include "dynamic_loader.h"

#ifndef __WIN32__
#include <dlfcn.h>


using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
DynamicLoader::DynamicLoader (const std::string& libName)
    : Factory(NULL, CL_NULL)
{
  this->setClassID(CL_DYNAMIC_LOADER, "DynamicLoader");

  this->handle = NULL;

  if (loadDynamicLib(libName));
  this->setName(&libName[0]);
}


/**
 * standard deconstructor
*/
DynamicLoader::~DynamicLoader ()
{
  // delete what has to be deleted here
  if (this->handle != NULL)
    dlclose(this->handle);
}


bool DynamicLoader::loadDynamicLib(const std::string& libName)
{
  this->handle = dlopen(&libName[0], RTLD_NOW);
  if(this->handle == NULL)
  {
    return false;
  }
  void *mkr = dlsym( this->handle, "maker");
}

bool DynamicLoader::loadDyLib(const std::string& libName)
{
  void* handle;
  handle = dlopen(&libName[0], RTLD_NOW);
  if(handle == NULL)
  {
    PRINTF(0)("unable to load %s\n", &libName[0]);
    return false;
  }
//  void *mkr = dlsym("maker");

}


BaseObject* DynamicLoader::fabricateObject(const TiXmlElement* root) const
{
}
#endif
