/*!
 * @file text.h
 * @brief Definition of a text Class, that is able to render text.
 */

#ifndef _TEXT_H
#define _TEXT_H

#include "element_2d.h"

#include "glincl.h"

#define  TEXT_ALIGN_LEFT             E2D_ALIGN_LEFT
#define  TEXT_ALIGN_RIGHT            E2D_ALIGN_RIGHT
#define  TEXT_ALIGN_CENTER           E2D_ALIGN_CENTER
#define  TEXT_ALIGN_SCREEN_CENTER    E2D_ALIGN_SCREEN_CENTER
#define  TEXT_DEFAULT_COLOR          Vector(1.0, 1.0, 1.0)      //!< the default Color (white)
#define  TEXT_DEFAULT_BLENDING       1.0f                       //!< the default blending of the text, (no blending at all)

#define  TEXT_DEFAULT_ALIGNMENT      TEXT_ALIGN_LEFT            //!< default alignment
#define  TEXT_DEFAULT_SIZE           20                         //!< default size of the Text


// FORWARD DECLARATION
class Font;
struct SDL_Surface;

//! A Struct to handel Texture Coordinates for quads
struct TexCoord
{
  float    minU;              //!< The minimum U-Coordinate
  float    maxU;              //!< The maximum U-Coordinate
  float    minV;              //!< The minimum V-Coordinate
  float    maxV;              //!< The maximum V-Coordinate
};

//! Represents one textElement.
class Text : public Element2D
{
  public:
    Text(const std::string& fontFile = "", unsigned int fontSize = TEXT_DEFAULT_SIZE);
    virtual ~Text();

    void setFont(const std::string& fontFile, unsigned int renderSize);

    void setText(const std::string& text);

    /** @returns the String this Text displays */
    inline const std::string& getText() const { return this->text; };
    /** @param blending the blending intensity to set (between 0.0 and 1.0) */
    inline void setBlending(float blending) { this->blending = blending; };
    /** sets the Color of the Text to render (values in [0-1]) @param r red @param g green @param b blue */
    void setColor(float r, float g, float b) { this->color = Vector(r, g, b); };
    /** sets the Size of the Font */
    void setSize(float size) { this->setSizeY2D(size); };
    /** @returns the Size of the Text */
//    void getSize(float &x, float& y) const { return this->size; };

    virtual void draw() const;

    void debug() const;

  // helpers.
    static GLuint loadTexture(SDL_Surface* surface, TexCoord* texCoord);
    static int powerOfTwo(int input);

  private:
    Font*             font;           //!< Font of this text

    std::string       text;           //!< The text to display
    Vector            color;          //!< The color of the font.
    float             blending;       //!< The blending intensity.
};

#endif /* _TEXT_H */
