/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: bottac@ee.ethz.ch
*/


// FORWARD DECLARATION
class  BspFile;
class BspTreeLeaf;
class BspTreeNode;
class Vector;
class set;
struct face;

class BspManager
{
public:
// Constructors
 BspManager();

// Functions
 void draw();
 void draw_leaf();
 void draw_debug_face(int Face);
 void draw_face(int Face);
 void draw_patch(face* Face);
 

private:
// Functions
 BspFile*  bspFile;
 BspTreeNode* root;
 BspTreeNode* getLeaf(BspTreeNode*  node, Vector* cam);  // Traverses the tree 
 void  checkCollision(BspTreeNode* node, Vector* cam);
 void drawDebugCube(Vector* cam);
 Vector cam;
 Vector ship;
 Vector  viewDir;
 bool * alreadyVisible;
 bool isAlreadyVisible(int Face);
 int lastTex;
};

