/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: bottac@ee.ethz.ch
*/


class BspTreeNode;
class Vector;
class Material;
class VertexArrayModel;

typedef struct 
{
  float x;
  float y;
  float z;
  float d;	
} plane;

typedef struct
{
   float mins [3]; //Bounding box min coord.
   float maxs [3]; //Bounding box max coord.
   int face; //First face for model.
   int n_faces; //Number of faces for model.
   int brush; //First brush for model.
   int n_brushes; //
} model;

typedef struct
{
   int plane; //Plane index.
   int left; //Children indices. Negative numbers are leaf indices: -(leaf+1).
   int right;
   int mins[3]; //Integer bounding box min coord.
   int maxs[3]; //Integer bounding box max coord.
} node;

typedef struct
{
   int cluster; // 	Visdata cluster index.
   int area; // 	Areaportal area.
   int mins[3]; // Integer bounding box min coord.
   int maxs[3]; // Integer bounding box max coord.
   int leafface; // First leafface for leaf.
   int n_leaffaces; //Number of leaffaces for leaf.
   int leafbrush_first; // leafbrush for leaf.
   int n_leafbrushes; // Number of leafbrushes for leaf.
} leaf;

typedef struct
{
    int brushside; 	//First brushside for brush.
    int n_brushsides; 	//Number of brushsides for brush.
    int texture; 	//Texture index.
} brush;

typedef struct
{
    int plane; //Plane index.
    int texture; 	//Texture index.
} brushside;

 struct face
{
    int texture; 	// Texture index.
    int effect; 	// Index into lump 12 (Effects), or -1.
    int type; 	// Face type. 1=polygon, 2=patch, 3=mesh, 4=billboard
    int vertex; 	// Index of first vertex.
    int n_vertexes; // Number of vertices.
    int meshvert;   // Index of first meshvert.
    int n_meshverts; // Number of meshverts.
    int lm_index;  // Lightmap index.
    int lm_start [2]; // Corner of this face's lightmap image in lightmap.
    int lm_size[2]; // Size of this face's lightmap image in lightmap.
    float lm_origin [3] ;//  World space origin of lightmap.
    float lm_vecs [2][3];// World space lightmap s and t unit vectors.
    float normal[3];// Surface normal.
    int size [2] ;// Patch dimensions.
} ;

typedef struct
{
    float position[3]; // Vertex position.
    float texcoord[2][2]; // Vertex texture coordinates. 0=surface, 1=lightmap.
    float normal[3]; // Vertex normal.
    unsigned char color [4]; //  Vertex color. RGBA.
}BspVertex;

typedef struct
{
   int offset;
} meshvert;

typedef struct 
{
 float position [3];
} BspVec;

class  BspFile
{
 public:
 BspFile();
 int read(char* name);
 void build_tree();
 void load_textures();
 void tesselate(int iface);
 BspTreeNode* get_root();
 Material * loadMat(char* mat);

 BspTreeNode*  root;
 char header [280]; // Buffer for header of BSP-File
 char*  nodes; // Buffer to store BSP-Tree-Nodes	
 char*  leaves; // Buffer to store BSP-Tree-Leaves
 char*  planes; // Buffer to store planes separateing the space 
 char*  bspModels; // Buffer to store BSP-Model-List
 char*  leafFaces;  // Buffer to store leafFaces
 char*  faces; //
 char*  leafBrushes; // Buffer to store brush indice
 char*  brushes; // Buffer to store  brushes
 char*  brushSides; //
 char*  vertice; //
 char*  meshverts;
 char*  visData;
 char* textures;


 char*  patchVertice;
 char*  patchIndexes;
 char*  patchTrianglesPerRow;
 int**  patchRowIndexes;
 VertexArrayModel** VertexArrayModels;
 int 	   patchOffset;

 int numNodes;
 int numLeafs;
 int numVertex;
 int numPlanes;
 int numBspModels;
 int numLeafFaces;
 int numFaces;
 int numLeafBrushes;
 int numTextures;
 int numPatches;
 int numBrushSides;
 
 BspTreeNode*  build_tree_rec(int i);
 Material**           Materials;

 
};

