/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: bottac@ee.ethz.ch
*/

#include "bsp_file.h"
#include "bsp_tree_node.h"
#include <fstream>
#include <sys/stat.h>
#include <string.h>
#include "debug.h"
#include "material.h"
#include "util/loading/resource_manager.h"

#include "vertex_array_model.h"
// Necessary ?
#include "base_object.h"
#include "vector.h"

using namespace std;


// Constructor
BspFile::BspFile()
{

}

int BspFile::read(char* in_name)
{
  int offset;
  int size;
  struct stat results;
   char name [300];
	  strcpy(name,ResourceManager::getFullName(in_name).c_str());
  
   if (stat( name , &results) == 0)
  {
     PRINTF(0)("BSP FILE: Datei gefunden. \n");
     ifstream bspFile (name, ios::in | ios::binary);
     bspFile.read(this->header, 260);
     PRINTF(0)("BSP FILE: BSPVersion: %i. \n", ((int *)(header) )[1]);
     if((((int *)(header) )[1]) == 46)    PRINTF(0)("BSP FILE: This is the good one! :-)  \n");
     else    PRINTF(0)("BSP FILE: Wrong BSPVersion.\n");

     // Get the Nodes
    offset = ((int *)(header) )[8];
    size    = ((int *)(header))[9];
    PRINTF(0)("BSP FILE: NodeSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumNodes: %i. \n", size / 36);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size %36);
    PRINTF(0)("BSP FILE: NodeOffset: %i. \n", offset);
    this->numNodes = size/36;
    this->nodes = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->nodes, size);

     // and their Planes
    offset = ((int *)(header) )[6];
    size    = ((int *)(header))[7];
    PRINTF(0)("BSP FILE: PlanesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumPlanes: %i. \n", size / 16);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size %16);
    PRINTF(0)("BSP FILE: PlanesOffset: %i. \n", offset);
    this->numPlanes = size/16;
    this->planes = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->planes, size);

     // Get the Leafs
    offset = ((int *)(header) )[10];
    size    = ((int *)(header))[11];
    PRINTF(0)("BSP FILE: LeaveSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumLeaves: %i. \n", size / 48);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 48);
    PRINTF(0)("BSP FILE: LeaveOffset: %i. \n", offset);
    this->numLeafs = size/48;
    this->leaves = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->leaves, size);

    // Get the Models
    offset = ((int *)(header))[16];
    size    = ((int *)(header))[17];
    PRINTF(0)("BSP FILE: ModelsSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumModels: %i. \n", size / 40);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 40);
    PRINTF(0)("BSP FILE: ModelsOffset: %i. \n", offset);
    this->numBspModels = size/40;
    this->bspModels = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->bspModels, size);

    // Get the leafFaces
    offset = ((int *)(header))[12];
    size    = ((int *)(header))[13];
    PRINTF(0)("BSP FILE: leafFacesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumleafFaces: %i. \n", size / 4);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 4);
    PRINTF(0)("BSP FILE: leafFacesOffset: %i. \n", offset);
    this->numLeafFaces = size/4;
    this->leafFaces = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->leafFaces, size);

    // Get the leafBrushes
    offset = ((int *)(header))[14];
    size    = ((int *)(header))[15];
    PRINTF(0)("BSP FILE: leafBrushesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumleafBrushes: %i. \n", size / 4);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 4);
    PRINTF(0)("BSP FILE: leafBrushesOffset: %i. \n", offset);
    this->numLeafBrushes = size/4;
    this->leafBrushes = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->leafBrushes, size);

    // Get the brushes
    offset = ((int *)(header))[18];
    size    = ((int *)(header))[19];
    PRINTF(0)("BSP FILE: BrushesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumBrushes: %i. \n", size / 12);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 12);
    PRINTF(0)("BSP FILE: BrushesOffset: %i. \n", offset);
    this->brushes = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->brushes, size);

    // Get the brushSides
    offset = ((int *)(header))[20];
    size    = ((int *)(header))[21];
    PRINTF(0)("BSP FILE: BrushSidesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumBrushSides: %i. \n", size / 8);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 8);
    PRINTF(0)("BSP FILE: BrushSidesOffset: %i. \n", offset);
    this->brushSides = new char [size];
    this->numBrushSides = size/8;
    bspFile.seekg(offset);
    bspFile.read(this->brushSides, size);

    // Get the Vertice
    offset = ((int *)(header))[22];
    size    = ((int *)(header))[23];
    PRINTF(0)("BSP FILE: VerticeSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumVertice: %i. \n", size / 44);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 44);
    PRINTF(0)("BSP FILE: VerticeOffset: %i. \n", offset);
    this->numVertex = size/44;
    this->vertice = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->vertice, size);

    // Get the MeshVerts
    offset = ((int *)(header))[24];
    size    = ((int *)(header))[25];
    PRINTF(0)("BSP FILE: MeshVertsSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumMeshVerts: %i. \n", size / 4);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 4);
    PRINTF(0)("BSP FILE: MeshVertsOffset: %i. \n", offset);
    this->meshverts = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->meshverts, size);

    // Get the Faces
    offset = ((int *)(header))[28];
    size    = ((int *)(header))[29];
    PRINTF(0)("BSP FILE: FacesSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumFaces: %i. \n", size / 104);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 104);
    PRINTF(0)("BSP FILE: FacesOffset: %i. \n", offset);
    this->numFaces = size/104;
    this->faces = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->faces, size);

    // Get the Visdata
    offset = ((int *)(header))[34];
    size    = ((int *)(header))[35];

    this->visData = new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->visData, size);

    PRINTF(0)("BSP FILE: VisDataSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumVisData: %i. \n", size /1 - 8);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 1);
    PRINTF(0)("BSP FILE: VisDataOffset: %i. \n", offset);

    // Get the Textures
    offset = ((int *)(header))[4];
    size    = ((int *)(header))[5];

    this->textures= new char [size];
    bspFile.seekg(offset);
    bspFile.read(this->textures, size);

    PRINTF(0)("BSP FILE: TextureSize: %i Bytes. \n", size);
    PRINTF(0)("BSP FILE: NumTextures: %i. \n", size /72);
    PRINTF(0)("BSP FILE: Remainder: %i. \n", size % 72);
    PRINTF(0)("BSP FILE: TextureOffset: %i. \n", offset);
    this->numTextures = size/72;

     bspFile.close();
	
   for(int i = 0 ; i < this->numTextures; i++)
   PRINTF(0)("BSP FILE: Texture 0: %s. \n", &this->textures[8+ 72*i]);
   this->load_textures();

   // Get the number of patches
   this->numPatches = 0;
   this->patchOffset   = 0;

   for( int i = 0; i < this->numFaces; i++)
	{
	face& cFace = ((face *)(this->faces))[i];
	if (	cFace.type == 2) 
		this->numPatches += (cFace.size[0] -1 ) / 2  * (cFace.size[1] -1) / 2;
	}

    // Allocate Memory 
 	this->patchVertice = new char[8*8*44*(this->numPatches+10)];
	this->patchIndexes = new char[7*8*2*4*(this->numPatches+10)];
	this->patchRowIndexes = new int*[7*4*this->numPatches];
	this->patchTrianglesPerRow = new char[7*4*this->numPatches];
	this->VertexArrayModels  = new VertexArrayModel*[this->numPatches];

    PRINTF(0)("BSP FILE:NumberOfPatches: %i . \n", numPatches);
    // Do tesselation for all Faces of type 2
   for( int i = 0; i < this->numFaces; i++)
	{
	if (	((face *)(this->faces))[i].type == 2) 
		this->tesselate(i);
	}

  PRINTF(0)("BSP FILE:PatchOffset: %i . \n", this->patchOffset);

     return  1; 
  }
  else
  {
     PRINTF(0)("BSP FILE: Datei nicht gefunden. \n");
     return -1;
  }
 
}

void BspFile::build_tree()
{

   PRINTF(0)("BSP FILE:\n");
   PRINTF(0)("BSP FILE: Building Tree...\n");
   root = this->build_tree_rec(0);
   PRINTF(0)("BSP FILE: ...done. \n");
   PRINTF(0)("BSP FILE:  \n");
   PRINTF(0)("BSP FILE: Node #0: \n");
   PRINTF(0)("BSP FILE:  x: %f \n",root->plane.x);
   PRINTF(0)("BSP FILE:  y: %f\n",root->plane.y);
   PRINTF(0)("BSP FILE:  z: %f\n",root->plane.z);
}

BspTreeNode*   BspFile::build_tree_rec(int i)
{
   // PRINTF(0)("BSP FILE: Node #%i\n", i);
   BspTreeNode* thisNode = new BspTreeNode();
   int left =(((node *) nodes) [i]).left;
   int right =(((node *) nodes) [i]).right;
   int planeIndex = (((node *) nodes) [i]).plane;
   float x1 =(((plane *) this->planes) [planeIndex]).x;
   float y1 =(((plane *) this->planes) [planeIndex]).y;
   float z1 =(((plane *) this->planes) [planeIndex]).z;
   thisNode->leafIndex = 0;
   thisNode->d	       = (((plane *) this->planes) [planeIndex]).d;
   
   thisNode->plane = Vector(x1,y1,z1);
   thisNode->isLeaf = false;

   if(left >= 0)
   {
       thisNode->left = this->build_tree_rec(left);
   }
   else
   {
	//BspTreeLeaf tmp =  BspTreeLeaf();
	//tmp.isLeaf = true;
	//tmp.leafIndex = -left -1;
        //thisNode->left = (BspTreeNode*) (&tmp);
	thisNode->left  = new BspTreeNode();
	thisNode->left->isLeaf = true;
	thisNode->left->leafIndex = - (left +1);
	//PRINTF(0)("BSP FILE:  LeafIndex: %i\n",-left);
   } // assign leav
   if(right >= 0)
   {
       thisNode->right =  this->build_tree_rec(right);
   }
   else
  {
	//BspTreeLeaf tmp =  BspTreeLeaf();
	//tmp.isLeaf = true;
	//tmp.leafIndex = -right -1;
        //thisNode->right = (BspTreeNode*) (&tmp);
	thisNode->right = new BspTreeNode();
	thisNode->right->isLeaf = true;
	thisNode->right->leafIndex = -(right +1);
	//PRINTF(0)("BSP FILE:  LeafIndex: %i\n",-right);
  } // assign leav
 return thisNode;
}

BspTreeNode* BspFile::get_root()
{
return root;
}

void BspFile::load_textures()
{
  const char* absFileName;
  char fileName [228];
  char ext [100];
  struct stat results;

  this->Materials = new Material* [this->numTextures];
  for(int i = 0 ; i < this->numTextures; i++)
  {
    PRINTF(0)("BSP FILE: Texture : %s. \n", &this->textures[8+ 72*i]);
   
     // Check for tga
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".tga");
    strncat (fileName, ext, strlen(fileName));
    //strncat(absFileName,fileName,strlen(fileName));
    absFileName = ResourceManager::getFullName(fileName).c_str();
  
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
	this->Materials[i] = this->loadMat(fileName);
	continue;
    }
    // Check for TGA
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".TGA");
    strncat (fileName, ext, strlen(fileName));
   // strncat(absFileName,fileName,strlen(fileName));
    // absFileName = ResourceManager::getFullName(fileName); 
    absFileName = ResourceManager::getFullName(fileName).c_str();
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
	this->Materials[i] = this->loadMat(fileName);
	continue;
    }
    // Check for jpg
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".jpg");
    strncat (fileName, ext, strlen(fileName));
    //strncat(absFileName,fileName,strlen(fileName));
    // absFileName = ResourceManager::getFullName(fileName);   
    absFileName = ResourceManager::getFullName(fileName).c_str();
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
    	this->Materials[i] =this->loadMat(fileName);
	continue;
    }


   // Check for JPG
   strcpy(fileName, &this->textures[8+ 72*i]);
   //strcpy (absFileName,"/root/data/trunk/");
   strcpy(ext, ".JPG");
   strncat (fileName, ext, strlen(fileName));
   //strncat(absFileName,fileName,strlen(fileName));
   // absFileName = ResourceManager::getFullName(fileName);
    absFileName = ResourceManager::getFullName(fileName).c_str();
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
	this->Materials[i] =this->loadMat(fileName);
	continue;
    }

   // Check for jpeg
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".jpeg");
    strncat (fileName, ext, strlen(fileName));
    //strncat(absFileName,fileName,strlen(fileName));
   //  absFileName = ResourceManager::getFullName(fileName);
    absFileName = ResourceManager::getFullName(fileName).c_str();
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
 	this->Materials[i] =this->loadMat(fileName);
	continue;
    }


    // Check for JPEG
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".JPEG");
    strncat (fileName, ext, strlen(fileName));
    //strncat(absFileName,fileName,strlen(fileName));
    // absFileName = ResourceManager::getFullName(fileName);
    absFileName = ResourceManager::getFullName(fileName).c_str();
    PRINTF(0)("BSP FILE: %s . \n", absFileName);
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
        this->Materials[i] =this->loadMat(fileName);
	continue;
    }

   // Check for bmp
   strcpy(fileName, &this->textures[8+ 72*i]);
   //strcpy (absFileName,"/root/data/trunk/");
   strcpy(ext, ".bmp");
   strncat (fileName, ext, strlen(fileName));
   //strncat(absFileName,fileName,strlen(fileName));
  //  absFileName = ResourceManager::getFullName(fileName);
    absFileName = ResourceManager::getFullName(fileName).c_str();
 
    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
	this->Materials[i] =this->loadMat(fileName);
	continue;
    }

   // Check for BMP
    strcpy(fileName, &this->textures[8+ 72*i]);
    //strcpy (absFileName,"/root/data/trunk/");
    strcpy(ext, ".BMP");
    strncat (fileName, ext, strlen(fileName));
  //  strncat(absFileName,fileName,strlen(fileName));
   //  absFileName = ResourceManager::getFullName(fileName);
    absFileName = ResourceManager::getFullName(fileName).c_str();

    if(stat( absFileName , &results) == 0)
    {
        PRINTF(0)("BSP FILE: gefunden . \n");
    	this->Materials[i] = this->loadMat(fileName);
	continue;
    }
	// 	Default Material
   	this->Materials[i] = new Material();
 	this->Materials[i]->setDiffuse(0.1,0.1,0.1);
   	this->Materials[i]->setAmbient(0.1,0.1,0.1 );
   	this->Materials[i]->setSpecular(0.4,0.4,0.4);
   	//this->Materials[i]->setShininess(100.0);
   	this->Materials[i]->setTransparency(1.0);
	this->Materials[i]->setDiffuseMap("pictures/ground.tga");
   	this->Materials[i]->setAmbientMap("pictures/ground.tga");
        this->Materials[i]->setSpecularMap("pictures/ground.tga");
  }
}


Material* BspFile::loadMat(char* mat)
{
  Material* tmp = new Material();
 	tmp->setDiffuse(1.0,1.0,1.0);
   	tmp->setAmbient(1.0,1.0,1.0 );
   	tmp->setSpecular(1.0,1.0,1.0);
   //	tmp->setShininess(.5);
   	tmp->setTransparency(1.0);

   	tmp->setDiffuseMap(mat);
   	tmp->setAmbientMap(mat);
        tmp->setSpecularMap(mat);

  return tmp;
}

void BspFile::tesselate(int iface)
{
	 face*  Face =  & (((face *)(this->faces))[iface]);
	 BspVertex *  BspVrtx = (BspVertex*)this->vertice; 
	 int level = 7;
	 int level1 = 8;

	// For each patch...
	for(int i = 0; i <(Face->size[0] - 1)    ; i+=2)
	{
		for(int j = 0; j <(Face->size[1] -1)    ; j+=2)
		{ 

			
			// Make a patch...
			// Get controls[9];
		        BspVec controls[9];
			BspVec controlsTmp[9]; 
			BspVertex VControls[9];
			for(int k = 0; k < 3; k++)
			{
				for(int l = 0; l < 3; l++)
				{
					controls[k +3*l]. position[0] =   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].position[0];
					controls[k +3*l]. position[1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].position[1];
					controls[k +3*l]. position[2] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i + l+ Face->size[0]*k].position[2]; /*Face->n_vertexes*/ 

				       controlsTmp[2-k +6-3*l]. position[0] =   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].position[0];
					controlsTmp[2-k +6-3*l]. position[1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].position[1];
					controlsTmp[2-k +6-3*l]. position[2] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i + l+ Face->size[0]*k].position[2]; /*Face->n_vertexes*/ 

					VControls[k +3*l]. position[0] =   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].position[0];
					VControls[k +3*l]. position[1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].position[1];
					VControls[k +3*l]. position[2] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i + l+ Face->size[0]*k].position[2];

					VControls[k +3*l]. normal[0] =   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].normal[0];
					VControls[k +3*l]. normal[1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].normal[1];
					VControls[k +3*l]. normal[2] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i + l+ Face->size[0]*k].normal[2];

					VControls[k +3*l]. texcoord[0][0]=   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].texcoord[0][0];
					VControls[k +3*l]. texcoord[0][1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].texcoord[0][1];
					VControls[k +3*l]. texcoord[1][0] =   BspVrtx[Face->vertex +( j * Face->size[0])+ i + l+ Face->size[0]*k].texcoord[1][0];
					VControls[k +3*l]. texcoord[1][1] =   BspVrtx[Face->vertex + (j * Face->size[0])+ i +l+ Face->size[0]*k].texcoord[1][1];
					

				}
			}
			//***********************************************************************************************************************
			// Compute the vertice
			//***********************************************************************************************************************
			float px, py;
			BspVertex temp[3];
			BspVertex* Vertice = &(((BspVertex*)this->patchVertice)[level1*level1*this->patchOffset]);

			for(int v=0; v<=level; ++v)
			{
					px=(float)v/level;

					Vertice[v].position[0]=VControls[0].position[0]*((1.0f-px)*(1.0f-px))+VControls[3].position[0]*((1.0f-px)*px*2)+VControls[6].position[0]*(px*px);
					Vertice[v].position[1]=VControls[0].position[1]*((1.0f-px)*(1.0f-px))+VControls[3].position[1]*((1.0f-px)*px*2)+VControls[6].position[1]*(px*px);
					Vertice[v].position[2]=VControls[0].position[2]*((1.0f-px)*(1.0f-px))+VControls[3].position[2]*((1.0f-px)*px*2)+VControls[6].position[2]*(px*px);

					Vertice[v].normal[0]=VControls[0].normal[0]*((1.0f-px)*(1.0f-px))+VControls[3].normal[0]*((1.0f-px)*px*2)+VControls[6].normal[0]*(px*px);
					Vertice[v].normal[1]=VControls[0].normal[1]*((1.0f-px)*(1.0f-px))+VControls[3].normal[1]*((1.0f-px)*px*2)+VControls[6].normal[1]*(px*px);
					Vertice[v].normal[2]=VControls[0].normal[2]*((1.0f-px)*(1.0f-px))+VControls[3].normal[2]*((1.0f-px)*px*2)+VControls[6].normal[2]*(px*px);

					Vertice[v].texcoord[0][0]=VControls[0].texcoord[0][0]*((1.0f-px)*(1.0f-px))+VControls[3].texcoord[0][0]*((1.0f-px)*px*2)+VControls[6].texcoord[0][0]*(px*px);
					Vertice[v].texcoord[0][1]=VControls[0].texcoord[0][1]*((1.0f-px)*(1.0f-px))+VControls[3].texcoord[0][1]*((1.0f-px)*px*2)+VControls[6].texcoord[0][1]*(px*px);
					Vertice[v].texcoord[1][0]=VControls[0].texcoord[1][0]*((1.0f-px)*(1.0f-px))+VControls[3].texcoord[1][0]*((1.0f-px)*px*2)+VControls[6].texcoord[1][0]*(px*px);
					Vertice[v].texcoord[1][1]=VControls[0].texcoord[1][1]*((1.0f-px)*(1.0f-px))+VControls[3].texcoord[1][1]*((1.0f-px)*px*2)+VControls[6].texcoord[1][1]*(px*px);
					
			}


			for(int u=1; u<=level; ++u)
			{
				py=(float)u/level;

					// temp[0]=controlPoints[0]*((1.0f-py)*(1.0f-py))+ controlPoints[1]*((1.0f-py)*py*2)+ controlPoints[2]*(py*py);
					temp[0].position[0]=VControls[0].position[0]*((1.0f-py)*(1.0f-py))+VControls[1].position[0]*((1.0f-py)*py*2)+VControls[2].position[0]*(py*py);
					temp[0].position[1]=VControls[0].position[1]*((1.0f-py)*(1.0f-py))+VControls[1].position[1]*((1.0f-py)*py*2)+VControls[2].position[1]*(py*py);
					temp[0].position[2]=VControls[0].position[2]*((1.0f-py)*(1.0f-py))+VControls[1].position[2]*((1.0f-py)*py*2)+VControls[2].position[2]*(py*py);

					temp[0].normal[0]=VControls[0].normal[0]*((1.0f-py)*(1.0f-py))+VControls[1].normal[0]*((1.0f-py)*py*2)+VControls[2].normal[0]*(py*py);
					temp[0].normal[1]=VControls[0].normal[1]*((1.0f-py)*(1.0f-py))+VControls[1].normal[1]*((1.0f-py)*py*2)+VControls[2].normal[1]*(py*py);
					temp[0].normal[2]=VControls[0].normal[2]*((1.0f-py)*(1.0f-py))+VControls[1].normal[2]*((1.0f-py)*py*2)+VControls[2].normal[2]*(py*py);

					temp[0].texcoord[0][0]=VControls[0].texcoord[0][0]*((1.0f-py)*(1.0f-py))+VControls[1].texcoord[0][0]*((1.0f-py)*py*2)+VControls[2].texcoord[0][0]*(py*py);
					temp[0].texcoord[0][1]=VControls[0].texcoord[0][1]*((1.0f-py)*(1.0f-py))+VControls[1].texcoord[0][1]*((1.0f-py)*py*2)+VControls[2].texcoord[0][1]*(py*py);
					temp[0].texcoord[1][0]=VControls[0].texcoord[1][0]*((1.0f-py)*(1.0f-py))+VControls[1].texcoord[1][0]*((1.0f-py)*py*2)+VControls[2].texcoord[1][0]*(py*py);
					temp[0].texcoord[1][1]=VControls[0].texcoord[1][1]*((1.0f-py)*(1.0f-py))+VControls[1].texcoord[1][1]*((1.0f-py)*py*2)+VControls[2].texcoord[1][1]*(py*py);
					
		

					// temp[1]=controlPoints[3]*((1.0f-py)*(1.0f-py))+ controlPoints[4]*((1.0f-py)*py*2)+ controlPoints[5]*(py*py);
					temp[1].position[0]=VControls[3].position[0]*((1.0f-py)*(1.0f-py))+VControls[4].position[0]*((1.0f-py)*py*2)+VControls[5].position[0]*(py*py);
					temp[1].position[1]=VControls[3].position[1]*((1.0f-py)*(1.0f-py))+VControls[4].position[1]*((1.0f-py)*py*2)+VControls[5].position[1]*(py*py);
					temp[1].position[2]=VControls[3].position[2]*((1.0f-py)*(1.0f-py))+VControls[4].position[2]*((1.0f-py)*py*2)+VControls[5].position[2]*(py*py);

					temp[1].normal[0]=VControls[3].normal[0]*((1.0f-py)*(1.0f-py))+VControls[4].normal[0]*((1.0f-py)*py*2)+VControls[5].normal[0]*(py*py);
					temp[1].normal[1]=VControls[3].normal[1]*((1.0f-py)*(1.0f-py))+VControls[4].normal[1]*((1.0f-py)*py*2)+VControls[5].normal[1]*(py*py);
					temp[1].normal[2]=VControls[3].normal[2]*((1.0f-py)*(1.0f-py))+VControls[4].normal[2]*((1.0f-py)*py*2)+VControls[5].normal[2]*(py*py);

					temp[1].texcoord[0][0]=VControls[3].texcoord[0][0]*((1.0f-py)*(1.0f-py))+VControls[4].texcoord[0][0]*((1.0f-py)*py*2)+VControls[5].texcoord[0][0]*(py*py);
					temp[1].texcoord[0][1]=VControls[3].texcoord[0][1]*((1.0f-py)*(1.0f-py))+VControls[4].texcoord[0][1]*((1.0f-py)*py*2)+VControls[5].texcoord[0][1]*(py*py);
					temp[1].texcoord[1][0]=VControls[3].texcoord[1][0]*((1.0f-py)*(1.0f-py))+VControls[4].texcoord[1][0]*((1.0f-py)*py*2)+VControls[5].texcoord[1][0]*(py*py);
					temp[1].texcoord[1][1]=VControls[3].texcoord[1][1]*((1.0f-py)*(1.0f-py))+VControls[4].texcoord[1][1]*((1.0f-py)*py*2)+VControls[5].texcoord[1][1]*(py*py);
					

					// temp[2]=controlPoints[6]*((1.0f-py)*(1.0f-py))+controlPoints[7]*((1.0f-py)*py*2)+controlPoints[8]*(py*py);
					temp[2].position[0]=VControls[6].position[0]*((1.0f-py)*(1.0f-py))+VControls[7].position[0]*((1.0f-py)*py*2)+VControls[8].position[0]*(py*py);
					temp[2].position[1]=VControls[6].position[1]*((1.0f-py)*(1.0f-py))+VControls[7].position[1]*((1.0f-py)*py*2)+VControls[8].position[1]*(py*py);
					temp[2].position[2]=VControls[6].position[2]*((1.0f-py)*(1.0f-py))+VControls[7].position[2]*((1.0f-py)*py*2)+VControls[8].position[2]*(py*py);

					temp[2].normal[0]=VControls[6].normal[0]*((1.0f-py)*(1.0f-py))+VControls[7].normal[0]*((1.0f-py)*py*2)+VControls[8].normal[0]*(py*py);
					temp[2].normal[1]=VControls[6].normal[1]*((1.0f-py)*(1.0f-py))+VControls[7].normal[1]*((1.0f-py)*py*2)+VControls[8].normal[1]*(py*py);
					temp[2].normal[2]=VControls[6].normal[2]*((1.0f-py)*(1.0f-py))+VControls[7].normal[2]*((1.0f-py)*py*2)+VControls[8].normal[2]*(py*py);

					temp[2].texcoord[0][0]=VControls[6].texcoord[0][0]*((1.0f-py)*(1.0f-py))+VControls[7].texcoord[0][0]*((1.0f-py)*py*2)+VControls[8].texcoord[0][0]*(py*py);
					temp[2].texcoord[0][1]=VControls[6].texcoord[0][1]*((1.0f-py)*(1.0f-py))+VControls[7].texcoord[0][1]*((1.0f-py)*py*2)+VControls[8].texcoord[0][1]*(py*py);
					temp[2].texcoord[1][0]=VControls[6].texcoord[1][0]*((1.0f-py)*(1.0f-py))+VControls[7].texcoord[1][0]*((1.0f-py)*py*2)+VControls[8].texcoord[1][0]*(py*py);
					temp[2].texcoord[1][1]=VControls[6].texcoord[1][1]*((1.0f-py)*(1.0f-py))+VControls[7].texcoord[1][1]*((1.0f-py)*py*2)+VControls[8].texcoord[1][1]*(py*py);
					
					
					

				for(int v=0; v<=level; ++v)
				{
					px=(float)v/level;

					//Vertice[u*(tesselation+1)+v]=	temp[0]*((1.0f-px)*(1.0f-px))+ temp[1]*((1.0f-px)*px*2)+ temp[2]*(px*px);
					Vertice[u*(level1)+v].position[0]=temp[0].position[0]*((1.0f-px)*(1.0f-px))+temp[1].position[0]*((1.0f-px)*px*2)+temp[2].position[0]*(px*px);
					Vertice[u*(level1)+v].position[1]=temp[0].position[1]*((1.0f-px)*(1.0f-px))+temp[1].position[1]*((1.0f-px)*px*2)+temp[2].position[1]*(px*px);
					Vertice[u*(level1)+v].position[2]=temp[0].position[2]*((1.0f-px)*(1.0f-px))+temp[1].position[2]*((1.0f-px)*px*2)+temp[2].position[2]*(px*px);

					Vertice[u*(level1)+v].normal[0]=temp[0].normal[0]*((1.0f-px)*(1.0f-px))+temp[1].normal[0]*((1.0f-px)*px*2)+temp[2].normal[0]*(px*px);
					Vertice[u*(level1)+v].normal[1]=temp[0].normal[1]*((1.0f-px)*(1.0f-px))+temp[1].normal[1]*((1.0f-px)*px*2)+temp[2].normal[1]*(px*px);
					Vertice[u*(level1)+v].normal[2]=temp[0].normal[2]*((1.0f-px)*(1.0f-px))+temp[1].normal[2]*((1.0f-px)*px*2)+temp[2].normal[2]*(px*px);

					Vertice[u*(level1)+v].texcoord[0][0]=temp[0].texcoord[0][0]*((1.0f-px)*(1.0f-px))+temp[1].texcoord[0][0]*((1.0f-px)*px*2)+temp[2].texcoord[0][0]*(px*px);
					Vertice[u*(level1)+v].texcoord[0][1]=temp[0].texcoord[0][1]*((1.0f-px)*(1.0f-px))+temp[1].texcoord[0][1]*((1.0f-px)*px*2)+temp[2].texcoord[0][1]*(px*px);
					Vertice[u*(level1)+v].texcoord[1][0]=temp[0].texcoord[1][0]*((1.0f-px)*(1.0f-px))+temp[1].texcoord[1][0]*((1.0f-px)*px*2)+temp[2].texcoord[1][0]*(px*px);
					Vertice[u*(level1)+v].texcoord[1][1]=temp[0].texcoord[1][1]*((1.0f-px)*(1.0f-px))+temp[1].texcoord[1][1]*((1.0f-px)*px*2)+temp[2].texcoord[1][1]*(px*px);
					


				}
			}

			//Create indices
			GLuint* indices= & ((GLuint*)(this->patchIndexes))[level*level1*2*this->patchOffset];
			
			for(int row=0; row<level; ++row)
			{
				for(int point=0; point<=level; ++point)
				{
					//calculate indices
					//reverse them to reverse winding
					indices[(row*(level1)+point)*2+1]=row*(level1)+point;
					indices[(row*(level1)+point)*2]=(row+1)*(level1)+point;
				}
			}


			//***********************************************************************************************************************
 			// Debug Model
			//***********************************************************************************************************************
			this->VertexArrayModels[this->patchOffset] = new VertexArrayModel();
			VertexArrayModel*  tmp = this->VertexArrayModels[this->patchOffset];
			tmp->newStripe();
				int a = 0;
				int b = -1;
				tmp->addVertex(controlsTmp[0].position[0],controlsTmp[0].position[1], controlsTmp[0].position[2]);	
				tmp->addNormal(1,0,0);
				tmp->addTexCoor(0.0,0.0);
				tmp->addColor(0.3,0.0,0.0);
				tmp->addIndice(1+b);
				tmp->addIndice(4+a);
				tmp->addVertex(controlsTmp[1].position[0],controlsTmp[1].position[1], controlsTmp[1].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,0.4);
				tmp->addColor(0.3,0.0,0.0);
				tmp->addIndice(2+b);
				tmp->addIndice(5+a);
				tmp->addVertex(controlsTmp[2].position[0],controlsTmp[2].position[1], controlsTmp[2].position[2]);	
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,1.0);
				tmp->addColor(0.1,0.0,0.0);
				tmp->addIndice(3+b);
				tmp->addIndice(6+a);
			
				tmp->addVertex(controlsTmp[2].position[0],controlsTmp[2].position[1], controlsTmp[2].position[2]);	
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,1.0);
				tmp->addColor(0.1,0.0,0.0);
				tmp->addIndice(7+a);
				//tmp->addIndice(6);
			
				tmp->newStripe();

				tmp->addVertex(controlsTmp[0].position[0],controlsTmp[0].position[1], controlsTmp[0].position[2]);	
				tmp->addNormal(1,0,0);
				tmp->addTexCoor(0.0,0.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(5+b);
				tmp->addIndice(8+a);
				tmp->addVertex(controlsTmp[1].position[0],controlsTmp[1].position[1], controlsTmp[1].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,0.4);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(6+b);
				tmp->addIndice(9+a);
				tmp->addVertex(controlsTmp[2].position[0],controlsTmp[2].position[1], controlsTmp[2].position[2]);	
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(7+b);
				tmp->addIndice(10+a);
				tmp->addVertex(controlsTmp[2].position[0],controlsTmp[2].position[1], controlsTmp[2].position[2]+0.01);	
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(0.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
				//tmp->addIndice(5);
				tmp->addIndice(11+a);
			
				tmp->newStripe();



				tmp->addVertex(controlsTmp[3].position[0],controlsTmp[3].position[1], controlsTmp[3].position[2]);	
				tmp->addNormal(0,1,0);
				tmp->addTexCoor(0.5,0.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(9+b);
				tmp->addIndice(12+a);
				tmp->addVertex(controlsTmp[4].position[0],controlsTmp[4].position[1], controlsTmp[4].position[2]);	
				tmp->addNormal(1,0,0);
				tmp->addTexCoor(0.5,0.5);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(10+b);
				tmp->addIndice(13+a);
				tmp->addVertex(controlsTmp[5].position[0],controlsTmp[5].position[1], controlsTmp[5].position[2]);	
				tmp->addNormal(1,0,0);
				tmp->addTexCoor(0.5,1.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(11+b);
				tmp->addIndice(14+a);
				tmp->addVertex(controlsTmp[5].position[0],controlsTmp[5].position[1], controlsTmp[5].position[2]+0.01);	
				tmp->addNormal(1,0,0);
				tmp->addTexCoor(0.5,1.0);
				tmp->addColor(0.1,0.1,0.1);
				
				tmp->addIndice(15+a);
				//tmp->addIndice(9);
				tmp->newStripe();

				tmp->addVertex(controlsTmp[6].position[0],controlsTmp[6].position[1], controlsTmp[6].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,0.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(13+b);	
				tmp->addIndice(16+a);	
				
				tmp->addVertex(controlsTmp[7].position[0],controlsTmp[7].position[1], controlsTmp[7].position[2]);
				tmp->addNormal(0,1,0);	
				tmp->addTexCoor(1.0,0.5);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(14+b);
				tmp->addIndice(17+a);	
				tmp->addVertex(controlsTmp[8].position[0],controlsTmp[8].position[1], controlsTmp[8].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(15+b);
				tmp->addIndice(18+a);	
				tmp->addVertex(controlsTmp[8].position[0],controlsTmp[8].position[1], controlsTmp[8].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(19+a);	
				//tmp->addIndice(13);

				tmp->newStripe();
				tmp->addVertex(controlsTmp[6].position[0],controlsTmp[6].position[1], controlsTmp[6].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,0.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(17+b);	
								
				tmp->addVertex(controlsTmp[7].position[0],controlsTmp[7].position[1], controlsTmp[7].position[2]);
				tmp->addNormal(0,1,0);	
				tmp->addTexCoor(1.0,0.5);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(18+b);
			
				tmp->addVertex(controlsTmp[8].position[0],controlsTmp[8].position[1], controlsTmp[8].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
				tmp->addIndice(19+b);
		
				tmp->addVertex(controlsTmp[8].position[0],controlsTmp[8].position[1], controlsTmp[8].position[2]);
				tmp->addNormal(1,0,0);	
				tmp->addTexCoor(1.0,1.0);
				tmp->addColor(0.1,0.1,0.1);
		
				tmp->newStripe();

				tmp->finalize();
				// End of DebugModel
				
			this->patchOffset++;
		}// For
	} // For

			// Overwrite Face->meshvert;
			// Overwrite Face->n_meshverts;
			int sz = (Face->size[0] -1)/2 * (Face->size[1] -1)/2; // num patches
			Face->meshvert = patchOffset -sz;  //3*(patchOffset-sz)*level1*level1;
			Face->n_meshverts = sz;
			PRINTF(0)("BSP FILE: sz: %i. \n", sz);
			PRINTF(0)("BSP FILE: Face->meshvert %i . \n", Face->meshvert);

			//Face->n_meshverts = sz; 
}
