/*!
 * @file quick_animation.h
 * Definition of the QuickAnimation-class
*/

#ifndef _QUICK_ANIMATION_H
#define _QUICK_ANIMATION_H

#include <vector>
// FORWARD DECLARATION

//! A class for that linearely interpolates between multiple values.
/**
 * QuickAnimation is a Class that creates a LookupTable with
 * position between [0.0f - 1.0f] so that one can resolve the
 * given Value.
 */
class QuickAnimation
{
public:
  QuickAnimation(unsigned int resolution = 100);
  virtual ~QuickAnimation();

  bool addKey(float position, float value);

  bool changeValueKey(unsigned int keyFrameNumber, float newValue);
  bool changeValue(float position, float newValue, float region = 0.04f);

  bool removeKey(unsigned int keyFrameNumber);
  bool remove(float position, float region = 0.04f);

  bool moveKey(unsigned int keyFrameNumber, float newPosition, float newValue);
  bool moveKey(unsigned int keyFrameNumber, float newPosition);
  bool move(float oldPosition, float newPosition, float newValue, float region = 0.04f);
  bool move(float oldPosition, float newPosition, float region = 0.04f);

  int getKeyAt(float position, float region = 0.04f);

  /**
   * @brief returns the value of the animation at a certain position
   * @param value returns the calculated value.
   * @param position The position to get the Value from.
   */
  void getValue(float& value, float position) const
  {
    value = this->lookupValues[int(position*this->lookupValues.size())];
  }

  /**
   * @brief returns the value of the animation at a certain position
   * @param position the position to get the value from :)
   * @returns the calculated Value.
   */
  float getValue(float position) const
  {
    return this->lookupValues[int(position*this->lookupValues.size())];
  }

  void debug() const;

private:
  void rebuild();

private:
  //! a simple struct that stores keyframes for the QuickAnimation-Class.
  struct QuickKeyFrame
  {
    //! Creates a new QuickKeyFrame with @param position position @param value value */
    QuickKeyFrame(float position, float value) :  position(position), value(value) {};
    //! compares this->position with position @param position pos to compare, @returns true on match.
    bool operator==(float position) { return this->position == position; };
    float            value;             //!< The value of this KeyFrame
    float            position;          //!< The position of thies KeyFrame

    static bool sortPositionPredicate(const QuickKeyFrame& key1, const QuickKeyFrame& key2);
    static bool sortValuePredicate(const QuickKeyFrame& key1, const QuickKeyFrame& key2);
  };

  std::vector<QuickKeyFrame>    keyFrames;              //!< An Array of KeyFrames.
  std::vector<float>            lookupValues;           //!< The lookup-table where the values are stored.
};

#endif /* _QUICK_ANIMATION_H */
