/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "ServerInformation.h"

#include <enet/enet.h>
#include <cassert>
#include <cstring>

#include "util/Serialise.h"

namespace orxonox
{
  namespace packet
  {
    
    ServerInformation::ServerInformation()
    {
      
    }
    
    ServerInformation::ServerInformation(ENetEvent* event)
    {
      // Save Server Round Trip Time
      this->serverRTT_ = event->peer->roundTripTime;
      // Save Server IP, leave some space for scope ID
      char* serverIP = new char[64];
      enet_address_get_host_ip(&event->peer->address, serverIP, 64);
      this->serverIP_ = std::string(serverIP);
      // Save ACK
      uint8_t* temp = event->packet->data;
      char* ack = new char[strlen(LAN_DISCOVERY_ACK)+1];
      loadAndIncrease((char*&)ack, temp);
      assert(strcmp(ack, (const char*)LAN_DISCOVERY_ACK)==0);
      // Save Server Name
      loadAndIncrease(this->serverName_, temp);
    }

    ServerInformation::~ServerInformation()
    {
      
    }

    void ServerInformation::send(ENetPeer* peer)
    {
      uint32_t size = returnSize((char*&)LAN_DISCOVERY_ACK) + returnSize(this->serverName_);
      uint8_t* temp = new uint8_t[size];
      uint8_t* temp2 = temp;
      saveAndIncrease((char*&)LAN_DISCOVERY_ACK, temp2);
      saveAndIncrease(this->serverName_, temp2);
      ENetPacket* packet = enet_packet_create( temp, size, 0 );
      enet_peer_send(peer, 0, packet);
      
      delete[] temp;
    }
  
  } // namespace packet
} // namespace orxonox

