/*!
  \file substring.h
  \brief a small class to get the parts of a string separated by commas
*/

#ifndef _SUBSTRING_H
#define _SUBSTRING_H

#include <vector>
#include <string>

typedef enum {
  SL_NORMAL,
  SL_ESCAPE,
  SL_SAFEMODE,
  SL_SAFEESCAPE,
  SL_COMMENT,
} SPLIT_LINE_STATE;

//! A class that can load one string and split it in multipe ones
/**
 * SubString is a very Powerfull way to create a SubSet from a String
 * It can be used, to Split strings append them and join them again.
 */
class SubString
{
public:
  SubString(const std::string& string = "", char splitter = ',');
  SubString(const std::string& string, bool whiteSpaces);
  SubString(const std::string& string, const std::string& splitters, char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');
  /** @brief create a Substring as a copy of another one. @param subString the SubString to copy. */
  SubString(const SubString& subString) { *this = subString; };
  SubString(const SubString& subString, unsigned int subSetBegin);
  SubString(const SubString& subString, unsigned int subSetBegin, unsigned int subSetEnd);
  ~SubString();

  // operate on the SubString
  SubString& operator=(const SubString& subString);
  bool operator==(const SubString& subString);
  SubString operator+(const SubString& subString) const;
  SubString& operator+=(const SubString& subString);
  /** @param subString the String to append @returns appended String. @brief added for convenience */
  SubString& append(const SubString subString) { return (*this += subString); };

  /////////////////////////////////////////
  // Split and Join the any String. ///////
  unsigned int split(const std::string& string = "", char splitter = ',');
  unsigned int split(const std::string& string, bool whiteSpaces);
  unsigned int split(const std::string& string, const std::string& splitters, char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');
  std::string join(const std::string& delimiter) const;
  ////////////////////////////////////////

  // retrieve a SubSet from the String
  SubString getSubSet(unsigned int subSetBegin) const;
  SubString getSubSet(unsigned int subSetBegin, unsigned int subSetEnd) const;

  // retrieve Information from within
  inline unsigned int size() const { return this->strings.size(); };
const std::string& getString(unsigned int i) const { return (i < this->strings.size()) ? this->strings[i] : emptyString; }
  ; // safety-precaution
  const std::string& operator[](unsigned int i) const { return this->getString(i); };
  unsigned int getOffset(unsigned int i) const;

  // the almighty algorithm.
  static SPLIT_LINE_STATE splitLine(std::vector<std::string>& ret,std::vector<unsigned int>& offsets,
                                    const std::string& line, const std::string& delimiters = " \t\r\n",
                                    char escape_char = '\\', char safemode_char = '"', char comment_char = '\0',
                                    SPLIT_LINE_STATE start_state = SL_NORMAL);
  // debugging.
  void debug() const;

private:
  std::vector<std::string>  strings;                      //!< strings produced from a single string splitted in multiple strings
  std::vector<unsigned int> offsets;                      //!< offsets of the beginning of the input-string to the beginning of each substring.

  static const std::string emptyString;
};

#endif /* _SUBSTRING_H */
