/*!
 * @file cmdline_parser.h
 * @brief Definition of ...
 */

#ifndef _CMD_LINE_PARSER_H
#define _CMD_LINE_PARSER_H

#include <list>
#include <string>
#include <vector>

#include "src/defs/debug.h"
#include "src/lib/util/multi_type.h"


struct ArgTableEntry
{
  int         id;
  std::string longOption;
  char        shortOption;
  int         numArgs;
  std::string argNames;
  std::string help;
};

typedef std::list<ArgTableEntry> ArgTable;

typedef bool (*ArgParserCallback)( ArgTableEntry, void*, const std::string &, const std::vector<MultiType> & );


//! A class for parsing command line arguments
class CmdLineParser {

  public:
    CmdLineParser();
    virtual ~CmdLineParser();
    
    bool add( int id, const std::string& longOption, char shortOption, int numArgs, const std::string & argNames, const std::string& help, bool back=false );

    bool parse( ArgParserCallback cb, void* data, int argc, char** argv );
    
    void showHelp();
    
  private:
    ArgTable argTable;
    std::string exeName;
    
    inline bool matches( ArgTableEntry entry, std::string arg, bool & finish );

};

#endif /* _CMD_LINE_PARSER_H */
