/*!
 * @file network_manager.h
  *  Main interface for the network module. Manages all the modules
*/

/* you will want to add such a a line at your header file also, since it will
   prevent c++ from including your code twice*/
#ifndef _NETWORK_MANAGER
#define _NETWORK_MANAGER

/* include this file, it contains some default definitions */
#include "netdefs.h"
#include "shared_network_data.h"

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"


/* forward declarations for the header file (include the header via #include "bla.h" in the source file) */
class NetworkStream;
class Synchronizeable;
template<typename>
class tList;

/* and here is the class itsself*/
class NetworkManager : public BaseObject
{

  public:

    inline static NetworkManager* getInstance() { if (!NetworkManager::singletonRef) NetworkManager::singletonRef = new NetworkManager();
      return NetworkManager::singletonRef; }
    virtual ~NetworkManager();

    void initialize();
    void shutdown();

    int establishConnection( const std::string & name, unsigned int port);
    int createServer(unsigned int port);

    /** Returns the hostID @return The hostID of the object */
    inline int getHostID() { return this->sharedNetworkData->getHostID(); }
    inline bool isGameServer() { return this->sharedNetworkData->isGameServer(); }


    void connectSynchronizeable(Synchronizeable& sync);
    void synchronize();

    void debug();


  private:
    NetworkManager();


  private:
    const std::list<BaseObject*>*    netStreamList;           // list with refs to all network streams
    const std::list<BaseObject*>*    syncList;                // list of synchronizeables
    static NetworkManager*           singletonRef;            //!< Pointer to the only instance of this Class
    NetworkStream*                   defaultSyncStream;       //!< FIXME: this is only for testing purposes

    SharedNetworkData*               sharedNetworkData;       //!< reference to the shared data
};



#endif /* _NETWORK_MANAGER */
