/*!
 * @file glgui_button.h
 * The gl_BUTTON widget of th openglGUI
 *
 */

#ifndef _GLGUI_BUTTON_H
#define _GLGUI_BUTTON_H

#include "glgui_widget.h"

typedef enum
{
  GLGui_Button_Active,
  GLGui_Button_Inactive,
  GLGui_Button_Pressed,
  GLGui_Button_Released,
  GLGui_Button_Activating,
  GLGui_Button_Deactivating,

} GLGui_ButtonState;

// FORWARD DECLARATION
class Text;

//! This is part of the openglGUI class
/**
 *
 */
class GLGuiButton : public GLGuiWidget {

 public:
   GLGuiButton();
   virtual ~GLGuiButton();

   void init();
   void setLabel(const std::string& label);

   virtual void draw() const;

  protected:
    Text*                label;

  private:
    GLGui_ButtonState    state;
};

#endif /* _GLGUI__H */
