/*!
 * @file billboard.h
 *  Definition of a billboard
 */

#ifndef _BILLBOARD_H
#define _BILLBOARD_H


#include "element_2d.h"

#include "vector.h"



class Model;
class Material;
class TiXmlElement;

//! A class that enables the
class Billboard :  public Element2D
{

  public:
    Billboard(const TiXmlElement* root = NULL);
    virtual ~Billboard();

    void init();
    void loadParams(const TiXmlElement* root);

    void setSize(float sizeX, float sizeY);
    void setTexture(const std::string& textureFile);
    void attachTo(PNode* pnode);

    virtual void tick(float dt);
    virtual void draw() const;


  private:
    Material*        material;             //!< a material for the Billboard
    float            rotationSpeed;        //!< Speed of the Rotation.

    PNode*           source;               //!< the source attached to it

};

#endif /* _BILLBOARD_H */
