/*!
 * @file movie_player.h
  *  Manages the media files

*/

#ifndef _MOVIE_PLAYER
#define _MOVIE_PLAYER

#include "sdlincl.h"

#ifdef HAVE_AVFORMAT_H
  #include <avformat.h>
#else
  #include <ffmpeg/avformat.h>
#endif

#include "glincl.h"
#include "texture.h"

// include base_object.h since all classes are derived from this one
#include "base_object.h"

// The state of the MoviePlayer
typedef enum MP_STATUS {
  PLAY,
  PAUSE,
  STOP
};

class MoviePlayer : public BaseObject
{

private:

  AVFormatContext* format_context;
  AVCodecContext* codec_context;
  AVCodec* codec;
  AVFrame* frame;
  AVPacket packet;
  AVFrame* RGB_frame;

  GLuint texture;
  uint8_t* data;
  uint8_t* buffer;
  int num_bytes;
  int video_stream;

  MP_STATUS status;
  float timer;
  int start_frame;
  int actual_frame;
  int frame_number;
  float fps;
  int duration;
  bool mediaLoaded;

public:

  MoviePlayer(const std::string& filename = "");
  virtual ~MoviePlayer();

  bool loadMovie(const std::string& filename);

  void start(float start_time);
  void resume();
  void pause();
  void stop();

  void tick(float dt);
  GLuint getTexture();

  void setFPS(float fps);
  float getFPS();
  const MP_STATUS getStatus();
  void printInformation();

private:

  void getNextFrame();
  void skipFrame(int frames);
  bool gotoFrame(int frames);

  void unloadMedia();

};

#endif // _MOVIE_PLAYER
