/**
 * @file lense_flare.h
 *  lense flare effect
 */

#ifndef _LENSE_FLARE
#define _LENSE_FLARE

#include "graphics_effect.h"

#include <vector>

#include "vector.h"
#include "plane.h"


#define LF_MAX_FLARES 7


class TiXmlElement;
class Light;
class Billboard;

//! A class that handles LenseFlares. The LenseFlareManager operates on this.
class LenseFlare : public GraphicsEffect
{
  public:
    LenseFlare(const TiXmlElement* root = NULL);
    virtual ~LenseFlare();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate();
    virtual bool deactivate();

    virtual void draw() const;
    virtual void tick(float dt);

    void addFlare(const std::string& textureName);


  private:
    GLint charToFogMode(const char* mode);
    void setSourceVisibility(bool visibility) ;


  private:
    float                    isVisible;          //!< Checks visibility
    Light*                   lightSource;        //!< reference to the sun (or primary light source)
    std::vector<Billboard*>  flares;             //!< the flares array

    Vector                   flareVector;        //!< the axis to draw the flares on
    float                    distance;           //!< distance from center to source
    Vector                   screenCenter;       //!< the vector marking the center of the screen

    float*                   flareMatrix;
    Plane                    frustumPlane;       //!< plane that marks the view frustum
};


#endif /* _LENSE_FLARE */
