/**
 * @file fog_effect.h
 *  atmospheric fog
 */

#ifndef _FOG_EFFECT
#define _FOG_EFFECT

#include "vector.h"
#include "graphics_effect.h"

class TiXmlElement;

//! A class that handles FogEffects. The FogEffectManager operates on this.
class FogEffect : public GraphicsEffect
{
  public:
    FogEffect(const TiXmlElement* root = NULL);
    virtual ~FogEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate();
    virtual bool deactivate();

    inline void setFogMode(const std::string& mode) { this->fogMode = this->stringToFogMode(mode); }
    inline void setFogDensity(float density) { this->fogDensity = density; }
    inline void setFogRange(float start, float end) { this->fogStart = start; this->fogEnd = end; }
    inline void setFogColor(float r, float g, float b) { this->colorVector = Vector(r, g, b); }


  private:
    GLint stringToFogMode(const std::string& mode);


  private:
    GLint                   fogMode;
    GLfloat                 fogDensity;
    GLfloat                 fogStart;
    GLfloat                 fogEnd;
    Vector                  colorVector;
};


#endif /* _FOG_EFFECT */
