/*!
  \file substring.h
  \brief a small class to get the parts of a string separated by commas
*/

#ifndef _SUBSTRING_H
#define _SUBSTRING_H

#include <vector>
#include <string>

  typedef enum {
    SL_NORMAL,
    SL_ESCAPE,
    SL_SAFEMODE,
    SL_SAFEESCAPE,
    SL_COMMENT,
  } SPLIT_LINE_STATE;

//! A class that can load one string and split it in multipe ones
class SubString
{
 public:
  SubString(const std::string& string = "", char splitter = ',');
  SubString(const std::string& string, bool whiteSpaces);
  SubString(const std::string& string, const std::string& splitters, char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');
  ~SubString();

  unsigned int split(const std::string& string = "", char splitter = ',');
  unsigned int split(const std::string& string, bool whiteSpaces);
  unsigned int split(const std::string& string, const std::string& splitters, char escapeChar ='\\', char safemode_char = '"', char comment_char = '\0');


  const std::string& operator[](unsigned int i) { return this->getString(i); };

  inline unsigned int getCount() { return this->strings.size(); };
  const std::string& getString(unsigned int i) { return (i < this->strings.size()) ? this->strings[i] : emptyString; };
  unsigned int getOffset(unsigned int i);

  static SPLIT_LINE_STATE splitLine(std::vector<std::string>& ret,std::vector<unsigned int>& offsets,
                                    const std::string& line, const std::string& delimiters = " \t\r\n",
                                    char escape_char = '\\', char safemode_char = '"', char comment_char = '\0',
                                    SPLIT_LINE_STATE start_state = SL_NORMAL);

  void debug() const;

 private:
   std::vector<std::string>  strings;                      //!< strings produced from a single string splitted in multiple strings
   std::vector<unsigned int> offsets;                      //!< offsets of the beginning of the input-string to the beginning of each substring.

   static const std::string emptyString;
};

#endif /* _SUBSTRING_H */
