/*!
 * @file orxonox.h
 * Orxonox core functions
*/

#ifndef _ORXONOX_H
#define _ORXONOX_H

#include "base_object.h"

class WorldEntity;
class GameLoader;
class IniParser;

//! orxonox core singleton class
/**
*/
class Orxonox : public BaseObject {

 public:
  virtual ~Orxonox ();
  /** @returns a Pointer to the only object of this Class */
  inline static Orxonox* getInstance() { if (!singletonRef) singletonRef = new Orxonox();  return singletonRef; };

  int init(int argc, char** argv, const char* name, int port);

  void restart();

  void start();

 private:
  Orxonox ();

  void parseIniFile(const char* fileName);

  int initResources ();
  int initVideo ();
  int initSound ();
  int initInput ();
  int initNetworking ();
  int initMisc ();

  const std::string& getConfigFile ();

 private:
  static Orxonox*   singletonRef;            //!< singleton reference to orxonox

  IniParser*        iniParser;               //!< Reference to the ini-parser used in orxonox
  std::string       configFileName;          //!< Filename of the configuration-file.
  GameLoader*       gameLoader;              //!< The gameLoader

  unsigned int      argc;                    //!< Count of Arguments of orxonox
  char**            argv;                    //!< Values of th Arguments of orxonox.

  const char*       serverName;              //!< Name of the Orxonox client if == NULL -> server
  int               port;                    //!< number of the network port of the server/client if == -1 no network
};


////////////////////////
// Start-up functions //
////////////////////////
int showHelp(int argc, char** argv);
int showLicense();
int startNetworkOrxonox(int argc, char** argv);
int startOrxonox(int argc, char** argv, const char* clientName, int port);

#endif /* _ORXONOX_H */

