/*!
 * @file helper_functions.h
 * @brief Definition of some minor helper-functions
*/

#ifndef _HELPER_FUNCTIONS_H
#define _HELPER_FUNCTIONS_H

#include <string>

// FORWARD DECLARATION

/***********************
*** HELPER FUNCTIONS ***
***********************/
bool          isBool(const char* BOOL, bool defaultValue);
int           isInt(const char* INT, int defaultValue);
float         isFloat(const char* FLOAT, float defaultValue);
const char*   isCString(const char* STRING, const char* defaultValue);
std::string   isString(const char* STRING, const std::string& defaultValue);


int           nocase_cmp(const std::string& s1, const std::string& s2);


#endif /* _HELPER_FUNCTIONS_H */
