/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "helper_functions.h"
#include "stdlibincl.h"

using namespace std;

/**
 * @brief checks if the input was a bool
 * @param BOOL a String that holds a bool: must be one of those: 1,0,true,false(case-insensitive)
 * @param defaultValue a default value that is set, if BOOL is corrupt
 * @return returns the bool, if BOOL was correct otherwise defaultValue
 */
bool isBool(const char* BOOL, bool defaultValue)
{
  if (BOOL == NULL)
    return defaultValue;
  if(!strcmp(BOOL, "1") || !strcasecmp( BOOL, "true") )
    return true;
  else if (!strcmp(BOOL, "0") || !strcasecmp( BOOL, "false"))
    return false;
  else
    return defaultValue;

}


/**
 * @brief checks if the input was a int
 * @param INT a String that holds an int.
 * @param defaultValue a default value that is set, if INT is corrupt
 * @return returns the contained int, if INT was correct otherwise defaultValue
 */
int isInt(const char* INT, int defaultValue)
{
  if (INT == NULL)
    return defaultValue;
  char* endPtr = NULL;

  int result = strtol(INT, &endPtr, 10);

  if ( endPtr >= INT && endPtr < INT + strlen(INT))
    return defaultValue;
  else
    return result;
}


/**
 * @brief checks if the input was a float
 * @param FLOAT a String that holds an float.
 * @param defaultValue a default value that is set, if FLOAT is corrupt
 * @return returns the contained float, if FLOAT was correct otherwise defaultValue
 */
float isFloat(const char* FLOAT, float defaultValue)
{
  if (FLOAT == NULL)
    return defaultValue;
  char* endPtr = NULL;
  double result = strtod(FLOAT, &endPtr);

  if ( endPtr >= FLOAT && endPtr < FLOAT + strlen(FLOAT))
    return defaultValue;
  else
    return result;
}


/**
 * @brief checks if the input was a string
 * @param STING a String(char-array) that holds an string.
 * @param defaultValue a default value that is set, if STRING is corrupt
 * @return returns the contained string (char-array), if STRING was correct otherwise defaultValue
 */
const char* isCString(const char* STRING, const char* defaultValue)
{
  if (STRING != NULL && strlen(STRING) > 0)
    return STRING;
  else
    return defaultValue;
}

/**
 * @brief checks if the input was a string
 * @param STING a String(char-array) that holds an string.
 * @param defaultValue a default value that is set, if STRING is corrupt
 * @return returns the contained string (char-array), if STRING was correct otherwise defaultValue
 */
std::string isString(const char* STRING, const std::string& defaultValue)
{
  if (STRING != NULL && strlen(STRING) > 0)
    return STRING;
  else
    return defaultValue;
}


/**
 * @brief compares two strings without ignoring the case
 * @param s1 first string
 * @param s2 second string
 */
int nocase_cmp(const std::string& s1, const std::string& s2)
{
  std::string::const_iterator it1=s1.begin();
  std::string::const_iterator it2=s2.begin();

  //stop when either string's end has been reached
  while ( (it1!=s1.end()) && (it2!=s2.end()) )
  {
    if(::toupper(*it1) != ::toupper(*it2)) //letters differ?
     // return -1 to indicate smaller than, 1 otherwise
      return (::toupper(*it1)  < ::toupper(*it2)) ? -1 : 1;
    //proceed to the next character in each string
    ++it1;
    ++it2;
  }
  size_t size1=s1.size(), size2=s2.size();// cache lengths
   //return -1,0 or 1 according to strings' lengths
  if (size1==size2)
    return 0;
  return (size1<size2) ? -1 : 1;
}

