/*!
 * @file sound_buffer.h
 * @brief Definition of the sound-buffer-class
*/

#ifndef _SOUND_BUFFER_H
#define _SOUND_BUFFER_H

#include "base_object.h"
#include "alincl.h"

// FORWARD DECLARATION
typedef struct SDL_AudioSpec;

//! A class that represents a datastructure to play Sounds.
class SoundBuffer : public BaseObject
{
  public:
    SoundBuffer(const std::string& fileName);
    virtual ~SoundBuffer();

    bool loadWAV(const std::string& fileName);

    /** @returns the ID of the buffer used in this SoundBuffer */
    inline ALuint getID() const { return this->bufferID; }

  private:
    ALenum sdlAudioSpecToAlFormat(const SDL_AudioSpec* audiospec);

  private:
    ALuint        bufferID;             //!< The address of the Buffer.

    ALsizei       size;                 //!< The size of the Buffer.
    ALboolean     loop;                 //!< loop information.
};

#endif /* _SOUND_BUFFER_H */
