/*!
 * @file key_mapper.h
  *  a construct to map player defined keys to SDL keys

*/

#ifndef _KEY_MAPPER_H
#define _KEY_MAPPER_H


#include "base_object.h"
//#include "event_def.h"

class IniParser;

//! A mapping from key-name to key-id
typedef struct orxKeyMapping
{
  int* pValue;
  char* pName;
};


//! The map class functionalities
class KeyMapper : public BaseObject {

 public:
  KeyMapper();
  virtual ~KeyMapper();

  void loadKeyBindings(const std::string& fileName = NULL);
  void loadKeyBindings(IniParser* iniParser);

  void debug();

 private:
  int* nameToIndex (const std::string& name);
  void mapKeys(const std::string& name, int* index);

 public:
  static int PEV_FORWARD;           //!< forward button
  static int PEV_BACKWARD;          //!< backward buttton
  static int PEV_LEFT;              //!< left button
  static int PEV_RIGHT;             //!< right button
  static int PEV_UP;                //!< up button
  static int PEV_DOWN;              //!< down button

  static int PEV_ROLL_LEFT;         //!< rolls left
  static int PEV_ROLL_RIGHT;        //!< rolls right

  static int PEV_STRAFE_LEFT;       //!< strafe left button
  static int PEV_STRAFE_RIGHT;      //!< strafe right button

  static int PEV_FIRE1;             //!< fire button 1
  static int PEV_FIRE2;             //!< fire button 2
  static int PEV_PREVIOUS_WEAPON;   //!< prev weapon button
  static int PEV_NEXT_WEAPON;       //!< next weapon button

  static int PEV_CHANGE_SHIP;       //!< The button to change the Ship.

  static int PEV_VIEW0;             //!< view 0 button
  static int PEV_VIEW1;             //!< view 1 button
  static int PEV_VIEW2;             //!< view 2 button
  static int PEV_VIEW3;             //!< view 3 button
  static int PEV_VIEW4;             //!< view 4 button
  static int PEV_VIEW5;             //!< view 5 button

  static int PEV_NEXT_WORLD;        //!< next world button
  static int PEV_PREVIOUS_WORLD;    //!< prev world button

  static int PEV_PAUSE;             //!< pause button
  static int PEV_QUIT;              //!< quit button

 private:
  int         coord[2];              //!< temp place to save variables in nameToIndex() function
};




#endif /* _KEY_MAPPER_H */
