/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer

   This code was inspired by the command_node.cc code from Christian Meyer in revision
   4386 and earlier.
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_EVENT

#include "key_mapper.h"

#include "event_def.h"

#include "globals.h"
#include "parser/ini_parser/ini_parser.h"
#include "key_names.h"
#include "debug.h"


using namespace std;


/* initialize all variables to a reasonable value*/
int KeyMapper::PEV_FORWARD           = EV_UNKNOWN;
int KeyMapper::PEV_BACKWARD          = EV_UNKNOWN;
int KeyMapper::PEV_LEFT              = EV_UNKNOWN;
int KeyMapper::PEV_RIGHT             = EV_UNKNOWN;
int KeyMapper::PEV_UP                = EV_UNKNOWN;
int KeyMapper::PEV_DOWN              = EV_UNKNOWN;
int KeyMapper::PEV_ROLL_LEFT         = EV_UNKNOWN;
int KeyMapper::PEV_ROLL_RIGHT        = EV_UNKNOWN;
int KeyMapper::PEV_STRAFE_LEFT       = EV_UNKNOWN;
int KeyMapper::PEV_STRAFE_RIGHT      = EV_UNKNOWN;

int KeyMapper::PEV_FIRE1             = EV_UNKNOWN;
int KeyMapper::PEV_FIRE2             = EV_UNKNOWN;
int KeyMapper::PEV_PREVIOUS_WEAPON   = EV_UNKNOWN;
int KeyMapper::PEV_NEXT_WEAPON       = EV_UNKNOWN;

int KeyMapper::PEV_CHANGE_SHIP       = EV_UNKNOWN;

int KeyMapper::PEV_VIEW0             = EV_UNKNOWN;
int KeyMapper::PEV_VIEW1             = EV_UNKNOWN;
int KeyMapper::PEV_VIEW2             = EV_UNKNOWN;
int KeyMapper::PEV_VIEW3             = EV_UNKNOWN;
int KeyMapper::PEV_VIEW4             = EV_UNKNOWN;
int KeyMapper::PEV_VIEW5             = EV_UNKNOWN;

int KeyMapper::PEV_NEXT_WORLD        = EV_UNKNOWN;
int KeyMapper::PEV_PREVIOUS_WORLD    = EV_UNKNOWN;

int KeyMapper::PEV_PAUSE             = EV_UNKNOWN;
int KeyMapper::PEV_QUIT              = EV_UNKNOWN;



//! this is the mapping array from names to ids: enter all orxonox.conf keys here
/** @todo use globals.h for this.... everything is done there for those Options,
 * and you do not have to care about The namings, as they might change
 */
orxKeyMapping map[] = {
  {&KeyMapper::PEV_FORWARD,              CONFIG_NAME_PLAYER_FORWARD},
  {&KeyMapper::PEV_BACKWARD,             CONFIG_NAME_PLAYER_BACKWARD},
  {&KeyMapper::PEV_UP,                   CONFIG_NAME_PLAYER_UP},
  {&KeyMapper::PEV_DOWN,                 CONFIG_NAME_PLAYER_DOWN},
  {&KeyMapper::PEV_LEFT,                 CONFIG_NAME_PLAYER_LEFT},
  {&KeyMapper::PEV_RIGHT,                CONFIG_NAME_PLAYER_RIGHT},
  {&KeyMapper::PEV_ROLL_LEFT,            CONFIG_NAME_PLAYER_ROLL_RIGHT},
  {&KeyMapper::PEV_ROLL_RIGHT,           CONFIG_NAME_PLAYER_ROLL_LEFT},
  {&KeyMapper::PEV_STRAFE_LEFT,          "StrafeLeft"},
  {&KeyMapper::PEV_STRAFE_RIGHT,         "StrafeRight"},

  {&KeyMapper::PEV_FIRE1,                CONFIG_NAME_PLAYER_FIRE},
  {&KeyMapper::PEV_FIRE1,                "Fire1"},
  {&KeyMapper::PEV_FIRE2,                "Fire2"},
  {&KeyMapper::PEV_NEXT_WEAPON,          CONFIG_NAME_PLAYER_NEXT_WEAPON},
  {&KeyMapper::PEV_PREVIOUS_WEAPON,      CONFIG_NAME_PLAYER_PREV_WEAPON},

  {&KeyMapper::PEV_CHANGE_SHIP,          CONFIG_NAME_PLAYER_CHANGE_SHIP},


  {&KeyMapper::PEV_VIEW0,                CONFIG_NAME_VIEW0},
  {&KeyMapper::PEV_VIEW1,                CONFIG_NAME_VIEW1},
  {&KeyMapper::PEV_VIEW2,                CONFIG_NAME_VIEW2},
  {&KeyMapper::PEV_VIEW3,                CONFIG_NAME_VIEW3},
  {&KeyMapper::PEV_VIEW4,                CONFIG_NAME_VIEW4},
  {&KeyMapper::PEV_VIEW5,                CONFIG_NAME_VIEW5},

  {&KeyMapper::PEV_NEXT_WORLD,           CONFIG_NAME_NEXT_WORLD},
  {&KeyMapper::PEV_PREVIOUS_WORLD,       CONFIG_NAME_PREV_WORLD},

  {&KeyMapper::PEV_PAUSE,                CONFIG_NAME_PAUSE},
  {&KeyMapper::PEV_QUIT,                 CONFIG_NAME_QUIT},
  {NULL, NULL}
};



/**
 *  standard constructor
*/
KeyMapper::KeyMapper ()
{
   this->setClassID(CL_KEY_MAPPER, "KeyMapper");
}


/**
 *  standard deconstructor
*/
KeyMapper::~KeyMapper ()
{
}


/**
 *  loads new key bindings from a file
 * @param filename: The path and name of the file to load the bindings from
*/
void KeyMapper::loadKeyBindings (const std::string& fileName)
{
  IniParser parser(fileName);
  this->loadKeyBindings(&parser);
}

void KeyMapper::loadKeyBindings(IniParser* iniParser)
{
  if( !iniParser->getSection (CONFIG_SECTION_PLAYER "1"))
  {
    PRINTF(1)("Could not find key bindings " CONFIG_SECTION_PLAYER"1\n");
    return;
  }
  int* index;

  iniParser->firstVar();
  while(iniParser->getCurrentName() != "")
  {
    PRINTF(3)("Keys: Parsing %s, %s now.\n", iniParser->getCurrentName(), iniParser->getCurrentValue());
    // map the name to an sdl index
    index = nameToIndex (iniParser->getCurrentValue());
    // map the index to a internal name
    this->mapKeys(iniParser->getCurrentName(), index);
    iniParser->nextVar();
  }


  // PARSE MISC SECTION
  if( !iniParser->getSection (CONFIG_SECTION_MISC_KEYS))
  {
    PRINTF(1)("Could not find key bindings" CONFIG_SECTION_MISC_KEYS "\n");
    return;
  }

  iniParser->firstVar();
  while(iniParser->getCurrentName() != "")
  {
    PRINTF(3)("MISC: Parsing %s, %s now.\n", iniParser->getCurrentName(), iniParser->getCurrentValue());
    index = nameToIndex (iniParser->getCurrentValue());
    this->mapKeys(iniParser->getCurrentName(), index);
    iniParser->nextVar();
  }
}

/**
 *  this function looks up name to key index
 * @param the name of the button
*/
int* KeyMapper::nameToIndex (const std::string& name)
{
  coord[0] = -1;
  coord[1] = -1;
  int c;
  if( (c = keynameToSDLK (name)) != -1) {
      coord[1] = c;
      coord[0] = 0;
    }
  if( (c = buttonnameToSDLB (name)) != -1) {
      coord[1] = c;
      coord[0] = 1;
    }
  return coord;
}


/**
 *  the function maps name to key ids
 * @param name of the key
 * @param id of the key
*/
void KeyMapper::mapKeys(const std::string& name, int* index)
{
  for( int i = 0; map[i].pValue != NULL; ++i )
    {
      if( name == map[i].pName)
      {
        if( index[0] == 0)
        {
          *map[i].pValue = index[1];
          PRINTF(4)("Mapping %s to '%s' (id %i)\n", name, SDLKToKeyname(index[1]), index[1]);
          break;
        }
        else {
          *map[i].pValue = index[1];
          PRINTF(4)("Mapping %s to '%s' (id %i)\n", name, SDLBToButtonname(index[1]), index[1]);
          break;
        }
      }
    }
}


/**
 *  this function gives some debug information about the key mapper class
*/
void KeyMapper::debug()
{
  PRINT(0)("\n==========================| KeyMapper::debug() |===\n");
  for(int i = 0; map[i].pValue != NULL; ++i)
    {
      PRINT(0)("%s = %i\n",map[i].pName, *map[i].pValue);
    }
  PRINT(0)("=======================================================\n");
}
