/*!
 * @file shader.h
 * @brief Definition of the Shader rendering class
*/

#ifndef _SHADER_H
#define _SHADER_H

#include "base_object.h"
#include "glincl.h"
#include <vector>


typedef enum
{
  SHADER_NONE       = 0,
  SHADER_FRAGMENT   = 1,
  SHADER_VERTEX     = 0,

} SHADER_TYPE;

// FORWARD DECLARATION


//! A class for ...
class Shader : public BaseObject {

  public:
  Shader(const std::string& vertexShaderFile = NULL, const std::string& fragmentShaderFile = NULL);
  virtual ~Shader();
  static Shader* getShader(const std::string& vertexShaderFile, const std::string& fragmentShaderFile);
  static bool unload(Shader* shader);

  bool loadShaderProgramm(SHADER_TYPE type, const std::string& fileName);
  void activateShader();
  static void deactivateShader();
  void deleteProgram(SHADER_TYPE type);

  char* fileRead(const std::string& fileName);
  std::vector<char*>* fileReadArray(const std::string& fileName);

  static bool checkShaderAbility();

  inline static bool shaderActive() { return (Shader::storedShader != NULL)? true : false; };
  inline static Shader* getActiveShader() { return Shader::storedShader; };
  inline static void suspendShader() { Shader* currShader = storedShader; if (storedShader!= NULL) { Shader::deactivateShader(); Shader::storedShader = currShader;} };
  inline static void restoreShader() { if (storedShader != NULL) storedShader->activateShader(); storedShader = NULL; };


  void printError(GLhandleARB program);
  void debug() const;

  private:

 private:
   std::string            fragmentShaderFile;
   std::string            vertexShaderFile;
   GLhandleARB            shaderProgram;
   GLhandleARB            vertexShader;
   GLhandleARB            fragmentShader;

   static Shader*         storedShader;
};

#endif /* _SHADER_H */
