/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "executor.h"

#include "debug.h"
#include "class_list.h"

#include "key_names.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

using namespace std;

////////////////////////
// SHELL COMMAND BASE //
////////////////////////
/**
 * constructs and registers a new Command
 * @param commandName the name of the Command
 * @param className the name of the class to apply this command to
 * @param paramCount the count of parameters this command takes
 */
Executor::Executor(const MultiType& param0,
                   const MultiType& param1,
                   const MultiType& param2,
                   const MultiType& param3,
                   const MultiType& param4)
{
  this->setClassID(CL_EXECUTOR, "Executor");

  // What Parameters have we got
  this->defaultValue[0] = param0;
  this->defaultValue[1] = param1;
  this->defaultValue[2] = param2;
  this->defaultValue[3] = param3;
  this->defaultValue[4] = param4;

  this->paramCount = 0;
  for (unsigned int i = 0; i < FUNCTOR_MAX_ARGUMENTS; i++)
  {
    if (this->defaultValue[i] == MT_NULL)
    {
      this->paramCount = i;
      break;
    }
  }
}

/**
 * deconstructs a Executor
 */
Executor::~Executor()
{}

/**
 * clones this element into executor.
 */
void Executor::cloning(Executor* executor) const
{
  executor->functorType  = this->functorType;
  executor->paramCount   = this->paramCount;
  for (unsigned int i = 0; i < this->paramCount; i++)
    executor->defaultValue[i] =  this->defaultValue[i];
}

/**
 * @brief set the default values of the executor
 * @param value0 the first default value
 * @param value1 the second default value
 * @param value2 the third default value
 * @param value3 the fourth default value
 * @param value4 the fifth default value
 * @returns itself
 */
Executor* Executor::defaultValues(const MultiType& value0,
                                  const MultiType& value1,
                                  const MultiType& value2,
                                  const MultiType& value3,
                                  const MultiType& value4)
{
  if (this == NULL)
    return NULL;

  const MultiType* value[5];
  value[0] = &value0;
  value[1] = &value1;
  value[2] = &value2;
  value[3] = &value3;
  value[4] = &value4;

  for (unsigned int i = 0; i < this->paramCount; i++)
  {
    if (*value[i] != MT_NULL)
        this->defaultValue[i].setValueOf(*value[i]);
  }
  return this;
}

/**
 * prints out nice information about the Executor
 */
void Executor::debug()
{
  /*  tIterator<ExecutorClass>* iteratorCL = ExecutorClass::commandClassList->getIterator();
    ExecutorClass* elemCL = iteratorCL->firstElement();
    while(elemCL != NULL)
    {
      PRINT(0)("Class:'%s' registered %d commands: \n", elemCL->className, elemCL->commandList->getSize());
      tIterator<Executor>* iterator = elemCL->commandList->getIterator();
      const Executor* elem = iterator->firstElement();
      while(elem != NULL)
      {
        PRINT(0)("  command:'%s' : params:%d: ", elem->getName(), elem->paramCount);
        for (unsigned int i = 0; i< elem->paramCount; i++)
         printf("%s ", Executor::paramToString(elem->parameters[i]));
        if (elem->description != NULL)
         printf("- %s", elem->description);
        printf("\n");

        elem = iterator->nextElement();
      }
      delete iterator;
      elemCL = iteratorCL->nextElement();
    }
    delete iteratorCL;*/
}
