/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "executor.h"

#include "debug.h"
#include "class_list.h"

#include "key_names.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

using namespace std;

////////////////////////
// SHELL COMMAND BASE //
////////////////////////
/**
 * constructs and registers a new Command
 * @param commandName the name of the Command
 * @param className the name of the class to apply this command to
 * @param paramCount the count of parameters this command takes
 */
Executor::Executor(const MultiType& param0,
                   const MultiType& param1,
                   const MultiType& param2,
                   const MultiType& param3,
                   const MultiType& param4)
{
  this->setClassID(CL_EXECUTOR, "Executor");


  // What Parameters have we got
  this->defaultValue[0] = param0;
  this->defaultValue[1] = param1;
  this->defaultValue[2] = param2;
  this->defaultValue[3] = param3;
  this->defaultValue[4] = param4;

  for (unsigned int i = 0; i < FUNCTOR_MAX_ARGUMENTS; i++)
  {
    printf("%d ", i);
    if (this->defaultValue[i] == MT_NULL)
    {
      this->paramCount = i;
      break;
    }

  }
  printf("%d\n", this->paramCount);

  assert (paramCount <= FUNCTOR_MAX_ARGUMENTS);
}

/**
 * deconstructs a Executor
 */
Executor::~Executor()
{}

/**
 * clones this element into executor.
 */
void Executor::cloning(Executor* executor) const
{
  executor->functorType  = this->functorType;
  executor->paramCount   = this->paramCount;
  for (unsigned int i = 0; i < this->paramCount; i++)
    executor->defaultValue[i] =  this->defaultValue[i];
}



/**
 * sets default Values of the Commands
 * @param count how many default Values to set.
 * @param ... the default Values in order. They will be cast to the right type
 * @returns itself
 *
 * Be aware, that when you use this Function, you !!MUST!! match the input as
 * count, [EXACTLY THE SAME AS IF YOU WOULD CALL THE FUNCTION UP TO count ARGUMENTS]
 */
Executor* Executor::defaultValues(unsigned int count, ...)
{
  va_list values;
  va_start(values, count);

  this->defaultValues(count, values);
}

Executor* Executor::defaultValues(unsigned int count, va_list values)
{
  if (this == NULL)
    return NULL;
  if (count == 0)
    return this;
  if (count > this->paramCount)
    count = this->paramCount;


  for (unsigned int i = 0; i < count; i++)
  {
    switch (this->defaultValue[i].getType())
    {
      case MT_BOOL:
        this->defaultValue[i].setInt(va_arg(values, int));
        break;
      case MT_CHAR:
        this->defaultValue[i].setChar((char)va_arg(values, int));
        break;
      case MT_STRING:
        this->defaultValue[i].setString(va_arg(values, char*));
        break;
      case MT_INT:
        this->defaultValue[i].setInt(va_arg(values, int));
        break;
        /*      case MT_UINT:
                this->defaultValue[i].setInt((int)va_arg(values, unsigned int));
                break;*/
      case MT_FLOAT:
        this->defaultValue[i].setFloat(va_arg(values, double));
        break;
        /*      case MT_LONG:
                this->defaultValue[i].setInt((int) va_arg(values, long));
                break;*/
      default:
        break;
    }
  }
  return this;
}

/**
 * prints out nice information about the Executor
 */
void Executor::debug()
{
  /*  tIterator<ExecutorClass>* iteratorCL = ExecutorClass::commandClassList->getIterator();
    ExecutorClass* elemCL = iteratorCL->firstElement();
    while(elemCL != NULL)
    {
      PRINT(0)("Class:'%s' registered %d commands: \n", elemCL->className, elemCL->commandList->getSize());
      tIterator<Executor>* iterator = elemCL->commandList->getIterator();
      const Executor* elem = iterator->firstElement();
      while(elem != NULL)
      {
        PRINT(0)("  command:'%s' : params:%d: ", elem->getName(), elem->paramCount);
        for (unsigned int i = 0; i< elem->paramCount; i++)
         printf("%s ", Executor::paramToString(elem->parameters[i]));
        if (elem->description != NULL)
         printf("- %s", elem->description);
        printf("\n");

        elem = iterator->nextElement();
      }
      delete iterator;
      elemCL = iteratorCL->nextElement();
    }
    delete iteratorCL;*/
}
