/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_MODEL

#include "model.h"

#include "glincl.h"

using namespace std;

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
Model::Model()
{
  this->setClassID(CL_MODEL, "Model");
  this->pModelInfo.numVertices = 0;
  this->pModelInfo.numTriangles = 0;
  this->pModelInfo.numNormals = 0;
  this->pModelInfo.numTexCoor = 0;

  this->pModelInfo.pVertices = NULL;
  this->pModelInfo.pTriangles = NULL;
  this->pModelInfo.pNormals = NULL;
  this->pModelInfo.pTexCoor = NULL;
}


/**
 * standard deconstructor
*/
Model::~Model()
{ }



void Model::draw() const
{
  const GLfloat* pVertices = NULL;
  const GLfloat* pNorm = NULL;

  glBegin(GL_TRIANGLES);
  for( int i = 0; i < this->pModelInfo.numTriangles; ++i)
    {
      //printf("int i = %i\n", i);
      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[0]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[0]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[1]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[1]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

      pNorm = &this->pModelInfo.pNormals[this->pModelInfo.pTriangles[i].indexToNormals[2]];
      pVertices = &this->pModelInfo.pVertices[this->pModelInfo.pTriangles[i].indexToVertices[2]];
      glNormal3f(pNorm[0], pNorm[1], pNorm[2]);
      glVertex3f(pVertices[0], pVertices[1], pVertices[2]);

    }
  glEnd();
}
