/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "collision_test_entity.h"

#include "util/loading/resource_manager.h"

#include "vector.h"
#include "objModel.h"
#include "obb_tree.h"
#include "util/loading/factory.h"

using namespace std;
CREATE_FACTORY(CollisionTestEntity, CL_ENVIRONMENT);

/**
 *  creates an environment
*/
CollisionTestEntity::CollisionTestEntity () : WorldEntity()
{
  this->init();
  this->loadModel("models/ships/reaplow.obj");
  //  this->loadModel("models/ships/figther.obj");

  this->buildObbTree(10);
}

/**
 * create an environment out of a XML-element
 * @param root the XML-element to load the CollisionTestEntity from
 */
CollisionTestEntity::CollisionTestEntity(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  deletes an environment
*/
CollisionTestEntity::~CollisionTestEntity ()
{}

/**
 * initialize an CollisionTestEntity
 */
void CollisionTestEntity::init()
{
  this->setClassID(CL_ENVIRONMENT, "CollisionTestEntity");
}

/**
 * loads the Settings of an CollisionTestEntity from an XML-element.
 * @param root the XML-element to load the ELements properties from
 */
void CollisionTestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}


/**
 *  ticks the environment
 * @param time the time about which to tick
*/
void CollisionTestEntity::tick (float time) {}


