/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "gravity.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

using namespace std;

CREATE_FACTORY(Gravity, CL_FIELD_GRAVITY);

Gravity::Gravity(const TiXmlElement* root)
{
  this->setClassID(CL_FIELD_GRAVITY, "Gravity");

  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor

*/
Gravity::~Gravity ()
{
  // delete what has to be deleted here
}

void Gravity::loadParams(const TiXmlElement* root)
{
  Field::loadParams(root);
}

/**
 *  calculates the Gravity on any point in space
 * @param data The Position of the Point in space to attache gravity to.
 * @returns The force.
*/
Vector Gravity::calcForce(const Vector& data) const
{
  return Vector(0,-1,0) * this->getMagnitude();
}


