/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "field.h"

#include "physics_engine.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"
using namespace std;

/**
 *  standard constructor
*/
Field::Field ()
{
  this->init();
}

/**
 *  standard deconstructor

*/
Field::~Field ()
{
   PhysicsEngine::getInstance()->removeField(this);
}

/**
  \brief initializes a Field
*/
void Field::init()
{
  this->setClassID(CL_FIELD, "Field");
  this->setMagnitude(1);
  this->setAttenuation(0);

  PhysicsEngine::getInstance()->addField(this);
}

/**
* @param root The XML-element to load settings from
 */
void Field::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);

  LoadParam(root, "magnitude", this, Field, setMagnitude)
      .describe("sets the magnitude of this Field")
      .defaultValues(1, 1);

  LoadParam(root, "attenuation", this, Field, setAttenuation)
      .describe("sets the attenuation of this Field.");

}

/**
 * @param magnitude the magnitude of the Field.
*/
void Field::setMagnitude(float magnitude)
{
  this->magnitude = magnitude;
}

/**
 * @param attenuation The attenuation of the Field (the bigger the smaller the region of influence)
*/
void Field::setAttenuation(float attenuation)
{
  this->attenuation = attenuation;
}
