/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_LOADING

#include "dynamic_loader.h"
#include "resource_manager.h"

using namespace std;

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
DynamicLoader::DynamicLoader (const std::string& libName)
{
  this->setClassID(CL_DYNAMIC_LOADER, "DynamicLoader");

  this->handle = NULL;

  if (loadDynamicLib(libName));
  this->setName(&libName[0]);
}

/**
 * @brief initializes the Dynamic Library loader
 * @returns true on succes, false otherwise
 */
bool DynamicLoader::initialize()
{
  if (lt_dlinit () != 0)
  {
    PRINTF(1)("Initializing LT_DL_LIB: %s\n", lt_dlerror());
    return false;
  }
  else
    return true;
}

/**
 * standard deconstructor
*/
DynamicLoader::~DynamicLoader ()
{
  // delete what has to be deleted here
  if (this->handle != NULL)
    lt_dlclose(this->handle);
}


bool DynamicLoader::loadDynamicLib(const std::string& libName)
{
  DynamicLoader::initialize();

  this->handle = lt_dlopen(&libName[0]);
  if(this->handle == NULL)
  {
    return false;
  }
}

bool DynamicLoader::loadDyLib(const char* libName)
{
  DynamicLoader::initialize();

  void* handle;
  handle = lt_dlopen(libName);
  if(handle == NULL)
  {
    PRINTF(1)("unable to load %s: %s\n", libName, lt_dlerror());

    return false;
  }

}

void DynamicLoader::addSearchDir(const char* searchDir)
{
  DynamicLoader::initialize();

  lt_dladdsearchdir(searchDir);
}

/**
 * @param relSearchDir: the Relative directory to add to searchPath of lt_dl
 * @returns true if the Path was Valid, false otherwise
 */
bool DynamicLoader::addSearchDirRelative(const char* relSearchDir)
{
  char* absSearchDir = ResourceManager::getAbsDir(relSearchDir);
  if (ResourceManager::isDir(absSearchDir))
  {
    DynamicLoader::addSearchDir(absSearchDir);
    delete[] absSearchDir;
    return true;
  }
  else
  {
    delete[] absSearchDir;
    return false;
  }
}

bool DynamicLoader::addSearchDirInLibDir(const char* relSearchDir)
{

}


const char* DynamicLoader::getSearchDir()
{
  return lt_dlgetsearchpath();
}
