/*!
 * @file dynamic_loader.h
 * @brief Definition of The Dynamic Loader Factory.
*/

#ifndef _DYNAMIC_LOADER_H
#define _DYNAMIC_LOADER_H

#include "factory.h"
#include "lib/libltdl/ltdl.h"

#include <string>

// FORWARD DECLARATION

//! A class for ...
class DynamicLoader : public BaseObject
{

public:
  DynamicLoader(const std::string& libName);
  virtual ~DynamicLoader();

  bool loadDynamicLib(const std::string& libName);

  static bool loadDyLib(const char* libName);

  static void addSearchDir(const char* searchDir);
  static bool addSearchDirRelative(const char* relSearchDir);
  static bool addSearchDirInLibDir(const char* relSearchDir);
  static const char* getSearchDir();

  static void unload();
private:
  // will be done automatically when using the this Engine.
  static bool initialize();

private:
  lt_dlhandle      handle;
};

#endif /* _DYNAMIC_LOADER_H */
