/*!
 * @file dynamic_loader.h
 * @brief Definition of The Dynamic Loader Factory.
*/

#ifndef _DYNAMIC_LOADER_H
#define _DYNAMIC_LOADER_H

#include "factory.h"
#include <ltdl.h>

#include <string>

// FORWARD DECLARATION

//! A class for ...
class DynamicLoader : public BaseObject
{

public:
  DynamicLoader(const std::string& libName);
  virtual ~DynamicLoader();

  bool loadDynamicLib(const std::string& libName);
  virtual BaseObject* fabricateObject(const TiXmlElement* root = NULL) const;

  static bool loadDyLib(const char* libName);


private:
  lt_dlhandle      handle;
};

#endif /* _DYNAMIC_LOADER_H */
