/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_LOADING

#include "dynamic_loader.h"


using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
DynamicLoader::DynamicLoader (const std::string& libName)
{
  this->setClassID(CL_DYNAMIC_LOADER, "DynamicLoader");

  this->handle = NULL;

  if (loadDynamicLib(libName));
  this->setName(&libName[0]);
}


/**
 * standard deconstructor
*/
DynamicLoader::~DynamicLoader ()
{
  // delete what has to be deleted here
  if (this->handle != NULL)
    lt_dlclose(this->handle);
}


bool DynamicLoader::loadDynamicLib(const std::string& libName)
{
  if (lt_dlinit () != 0)
  {
    PRINTF(1)("Initializing LT_DL_LIB\n");
  }
  this->handle = lt_dlopen(&libName[0]);
  if(this->handle == NULL)
  {
    return false;
  }
  //void *mkr = dlsym( this->handle, "maker");
}

bool DynamicLoader::loadDyLib(const char* libName)
{
  if (lt_dlinit () != 0)
  {
    PRINTF(1)("Initializing LT_DL_LIB\n");
  }

  void* handle;
  handle = lt_dlopen(libName);
  if(handle == NULL)
  {
    PRINTF(1)("unable to load %s: %s\n", libName, lt_dlerror());

    return false;
  }
//  void *mkr = dlsym("maker");

}


BaseObject* DynamicLoader::fabricateObject(const TiXmlElement* root) const
{
}
