# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

# original comes from http://www.orxonox.net/ , 2006-02-11
# modified/tested by S. Fuchs, http://srf.ch/ , 2006-02-11
#
# put this ebuild into your portage overlay: games-action/orxonox/
# see /etc/make.conf to configure the portage overlay.
# then cd into that games-action/orxonox/ directory and do:
# $ ebuild orxonox-0.3.2_alpha-r7122.ebuild digest
# $ emerge -av --oneshot orxonox
# to install it (ommit the --oneshot to get an entry in your world file).
#
# put http://fuchs.dnsalias.net/public/orxonox/orxonox-0.3.2_alpha-r7122.tar.bz2
# manually into your distfiles directory (usually /usr/portage/distfiles)
# if it's not available from http://www.orxonox.net/files/snapshots/

inherit eutils games

DATA_VERSION=372

DESCRIPTION="orxonox is an open-source 3D-action game programmed in C++, OpenGL, OpenAL and SDL"
HOMEPAGE="http://www.orxonox.net"
SRC_URI="http://www.orxonox.net/files/snapshots/${P}-${PR}.tar.bz2
         http://www.orxonox.net/files/snapshots/${PN}-data-r${DATA_VERSION}.tar.bz2"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="x86"
IUSE="gtk+-2"

DEPEND="virtual/opengl
        virtual/x11
        media-libs/openal
        media-libs/libsdl
        media-libs/sdl-image
        media-libs/sdl-ttf
        media-libs/sdl-net
        media-libs/glew"

# Run-time dependencies, same as DEPEND if RDEPEND isn't defined:
#RDEPEND=""
S=${WORKDIR}/${P}

src_unpack() {
        unpack ${P}-${PR}.tar.bz2
        cd "${S}"
        unpack ${PN}-data-r${DATA_VERSION}.tar.bz2
}

src_compile() {
        egamesconf || die

        emake || die "emake failed"
}

src_install() {
        make DESTDIR=${D} install || die

        dodir ${GAMES_DATADIR}/${PN}
        cp -r data/* ${D}/${GAMES_DATADIR}/${PN}/ \
                || die "data copy failed"

        dodoc AUTHORS ChangeLog README

        prepgamesdirs

        #make \
        #       prefix=${D}/usr \
        #       mandir=${D}/usr/share/man \
        #       infodir=${D}/usr/share/info \
        #       libdir=${D}/usr/$(get_libdir) \
        #       install || die

        #einstall || die
}

pkg_postinst() {
        games_pkg_postinst
}
