

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "factory.h"
#include "load_param.h"

#include "test_entity.h"
#include "stdincl.h"
#include "model.h"
#include "md2Model.h"
#include "obb_tree.h"
#include "state.h"

using namespace std;


CREATE_FACTORY(TestEntity, CL_TEST_ENTITY);


TestEntity::TestEntity ()
{
  this->init();
}



TestEntity::TestEntity(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


TestEntity::~TestEntity ()
{}



void TestEntity::init()
{
  this->setClassID(CL_TEST_ENTITY, "TestEntity");
  this->toList(OM_GROUP_00);
}

/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "md2animation", this, TestEntity, setAnim)
      .describe("sets the animation of the md2 model")
      .defaultValues(1, 1);

}


void  TestEntity::setAnim(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((MD2Model*)this->getModel(0))->setAnim(animationIndex, animPlaybackMode);
}


void TestEntity::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((MD2Model*)this->getModel(0))->tick(time);

}


void TestEntity::collidesWith(WorldEntity* entity, const Vector& location)
{
  if( this->lastCollided != entity)
  {
    this->dieHard();
    this->lastCollided = entity;
  }
}



void TestEntity::dieHard()
{
  this->setAnim(DEATH_FALLBACK, MD2_ANIM_ONCE);
}

