
/*!
 * @file playable.h
 * Interface for a basic controllable WorldEntity
 */
#ifndef _PLAYABLE_H
#define _PLAYABLE_H

#include "world_entity.h"
#include "extendable.h"
#include "event.h"
#include <list>

#include "world_entities/weapons/weapon_manager.h"

class Weapon;
class DotEmitter;
class Player;
class SpriteParticles;

//! Basic controllable WorldEntity
/**
 *
 */
class Playable : public WorldEntity, public Extendable
{
  public:
    virtual ~Playable();


    virtual void die();
    virtual void respawn();

    virtual bool pickup(PowerUp* powerUp);

    void addWeapon(Weapon* weapon, int configID = -1, int slotID = -1);
    void removeWeapon(Weapon* weapon);
    void nextWeaponConfig();
    void previousWeaponConfig();

    inline WeaponManager* getWeaponManager() const { return this->weaponMan; };
    void weaponConfigChanged();


    bool setPlayer(Player* player);
    Player* getCurrentPlayer() const { return this->currentPlayer; };

    void attachCamera();
    void detachCamera();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void process(const Event &event);

    virtual void tick(float dt);

    /** @return a List of Events in PEV_* sytle */
    inline const std::list<int>& getEventList() { return this->events; };

    int       writeSync(const byte* data, int length, int sender);
    int       readSync(byte* data, int maxLength );
    bool      needsReadSync();

    inline void setScore( int score ) { this->score = score; }
    inline int  getScore() { return this->score; }

  protected:
    Playable();

    virtual void enter() = 0;
    virtual void leave() = 0;

    void registerEvent(int eventType);
    void unregisterEvent(int eventType);

  private:
    WeaponManager*        weaponMan;          //!< the weapon manager: managing a list of weapon to wepaon-slot mapping
    std::list<int>        events;             //!< A list of Events, that are captured for this playable

    Player*               currentPlayer;      //!< The Player currently connected to this Playable (the one that has controll) otherwise NULL

    bool                  bFire;              //!< If the Ship is firing.
    int                   oldFlags;           //!< Used for synchronisation

    int                   score;
    int                   oldScore;

    //TODO HACK: explosion emitter
    DotEmitter*           emitter;
    SpriteParticles*      explosionParticles;

    WorldEntity* collider;
};

#endif /* _PLAYABLE_H */
