#ifndef _TEST_ENTITY_H
#define _TEST_ENTITY_H

#include "world_entity.h"
#include "physics_interface.h"

class MD2Loader;
class MD2Model;
class MD2Model2;
struct t3DModel;
class Material;
class TiXmlElement;

class TestEntity : public WorldEntity, public PhysicsInterface
{
  friend class World;

 public:
  TestEntity ();
  TestEntity(const TiXmlElement* root);
  virtual ~TestEntity ();

  void init();
  virtual void loadParams(const TiXmlElement* root);

  void setAnim(int animationIndex);

  void dieHard();

  virtual void tick (float time);
  virtual void collidesWith(WorldEntity* entity, const Vector& location);

 private:
  /* TESTING TESTING TESTING */
  t3DModel* model;
  MD2Model* md2Model;
  Material* material;

};

#endif /* _TEST_ENTITY_H */
