/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "hud.h"

#include "state.h"

#include "world_entities/weapons/weapon_manager.h"

using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
Hud::Hud ()
{
  this->setClassID(CL_HUD, "Hud");

  //this->setSize2D(
  this->weaponManager = NULL;
  this->energyWidget = NULL;
  this->shieldWidget = NULL;
  this->armorWidget = NULL;
  this->resX = 1;
  this->resY = 1;

}


/**
 * standard deconstructor
*/
Hud::~Hud ()
{
  // delete what has to be deleted here
}


void Hud::loadParams(const TiXmlElement* root)
{
  Element2D::loadParams(root);
}

void Hud::setBackGround()
{
}

void Hud::setEnergyWidget(GLGuiWidget* widget)
{
  // decopple old widget
  if (this->energyWidget != NULL)
  {
    this->energyWidget->hide();
  }

  this->energyWidget = widget;
  if (this->energyWidget != NULL)
  {
    this->energyWidget->show();
    this->energyWidget->backMaterial().setDiffuseMap("hud_energy_background.png");
    this->energyWidget->backMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    this->energyWidget->frontMaterial().setDiffuseMap("hud_energy_bar.png");
    this->energyWidget->frontMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  }

  this->updateResolution();
}

void Hud::setShiledWidget(GLGuiWidget* widget)
{
}

void Hud::setArmorWidget(GLGuiWidget* widget)
{
}

void Hud::setWeaponManager(WeaponManager* weaponMan)
{
  if (this->weaponManager != NULL)
  {
    for (unsigned int i = 0; i < this->weaponManager->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManager->getWeapon(i);
      if (weapon != NULL)
      {
        weapon->getEnergyWidget()->hide();
        this->weaponsWidgets.remove(weapon->getEnergyWidget());
      }
    }
  }

  this->weaponManager = weaponMan;

  this->updateWeaponManager();
  this->updateResolution();
}

void Hud::updateWeaponManager()
{
  // hide all the Widgets
  std::list<GLGuiWidget*>::iterator weaponWidget;
  for (weaponWidget = this->weaponsWidgets.begin(); weaponWidget != this->weaponsWidgets.end(); weaponWidget++)
  {
    (*weaponWidget)->hide();
  }
  this->weaponsWidgets.clear();

  // add all that we need again.
  if (this->weaponManager != NULL)
    for (unsigned int i = 0; i < this->weaponManager->getSlotCount(); i++)
  {
    Weapon* weapon = this->weaponManager->getWeapon(i);
    if (weapon != NULL)
    {
      weapon->getEnergyWidget()->show();
      weapon->getEnergyWidget()->backMaterial().setDiffuse( .8,.2,.11);
      weapon->getEnergyWidget()->backMaterial().setTransparency(.1);
      weapon->getEnergyWidget()->frontMaterial().setDiffuse( .2,.5,.7);
      weapon->getEnergyWidget()->frontMaterial().setTransparency(.6);
      this->weaponsWidgets.push_back(weapon->getEnergyWidget());
    }
  }
  this->updateResolution();
}

void Hud::addWeaponWidget(GLGuiWidget* widget)
{
}

void Hud::removeWeaponWidget(GLGuiWidget* widget)
{
}

void Hud::updateResolution()
{
  this->resX = State::getResX();
  this->resY = State::getResY();
  if (this->energyWidget != NULL)
  {
    this->energyWidget->setAbsCoor2D(0 * this->resX, 0 * this->resY);
    this->energyWidget->setSize2D(.25 * this->resX, 1 * this->resY);
  }

  this->setSize2D(.2 * this->resX, this->resY);

  std::list<GLGuiWidget*>::iterator weaponWidget;
  float pos = .3;
  for (weaponWidget = this->weaponsWidgets.begin(); weaponWidget != this->weaponsWidgets.end(); weaponWidget++, pos+=.03)
  {
      (*weaponWidget)->setSize2D(.02*this->resX, .2 *this->resY);
      (*weaponWidget)->setAbsCoor2D(pos*this->resX, .75*this->resY);

  }
}


void Hud::tick(float dt)
{
  if (this->resY != State::getResY() || this->resX != State::getResY())
    this->updateResolution();
}

void Hud::draw() const
{
//  GLGuiWidget::draw();
}


