/*!
 * @file simple_game_menu.h
 *  a StoryEntity that contains a simple game menu
 */

#ifndef _SIMPLE_GAME_MENU_H
#define _SIMPLE_GAME_MENU_H


#include "game_world.h"
#include "event_listener.h"
#include "game_world_data.h"
#include <vector>
#include "vector.h"


#include "elements/text_element.h"

class SimpleGameMenuData;
class TiXmlElement;
class ImageEntity;



class MenuLayer
{
  public:
    MenuLayer() {}
    virtual ~MenuLayer() {}


  public:
    std::vector<TextElement*>          menuList;                        //!< the list of the menu items
    std::vector<StoryEntity*>         storyList;                       //!< the list of the StoryEntities for the menu
    std::vector<ImageEntity*>         screenshootList;                 //!< list of the screen shoots FIXME: make a better structure for this stuff
};


//! a simple game menu based on a story entity
/**
 * This is a simple menu, that is based on the StoryEntity. Therefore this menu is absolutly
 * loadable and is exchangeable very easely :D
 */
class SimpleGameMenu : virtual public GameWorld, virtual public EventListener
{

  public:
    SimpleGameMenu(const TiXmlElement* root = NULL);
    virtual ~SimpleGameMenu();

    virtual void loadParams(const TiXmlElement* root);

    virtual ErrorMessage init();
    virtual ErrorMessage loadData();
    virtual ErrorMessage unloadData();

    virtual bool start();
    virtual bool stop();

    virtual void process(const Event &event);


  protected:
    virtual void tick();
    virtual void collide();


  private:
    void animateScene(float dt);
    void switchMenuLayer(int layer1, int layer2);
    void sliderTo(const Element2D* element, float bias = 0.0f);


  private:
    std::vector<MenuLayer>            menuLayers;                      //!< the menu layer
    MenuLayer*                        selectedLayer;                   //!< the selected menu layer
    int                               layerIndex;

    //std::vector<ImageEntity*>         menuList;                        //!< the list of the menu items
    ImageEntity*                      menuSelector;                    //!< ref to the selector image
    TextElement*                      menuSelected;                    //!< ref to the selected menu entity
    TextElement*                      menuStartGame;
    TextElement*                      menuStartMultiplayerGame;
    TextElement*                      menuQuitGame;
    int                               menuSelectedIndex;

    Vector                            cameraVector;
};



//! the simple game menu data
class SimpleGameMenuData : public GameWorldData
{

  public:
    SimpleGameMenuData();
    virtual ~SimpleGameMenuData();

    virtual ErrorMessage init();


  protected:
    virtual ErrorMessage loadGUI(TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(TiXmlElement* root);
    virtual ErrorMessage loadScene(TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();

};


#endif /* _GAME_WORLD_H */
